/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.jmi.query;

import java.util.Iterator;
import java.util.NoSuchElementException;

/** Alters the objects in the query to other objects.
 *
 * @author Petr Hrebejk
 */
public abstract class AlterQuery implements Query {

    private final Query QUERY;
    private final Alternator ALTERNATOR;
    
    AlterQuery(Query query) {
        this.QUERY = query;
        this.ALTERNATOR = null;
    }
    
    AlterQuery(Query query, Alternator alternator ) {
        this.QUERY = query;
        this.ALTERNATOR = alternator;
    }
    
    public Iterator iterator() {
        return new AlterIterator();
    }
    
    public boolean contains( Object object ) {
        return QUERY.contains( alterBack( object ) );
    }
    
    protected Object alter( Object object ) {
        if ( ALTERNATOR == null ) {
            return object;
        }
        else {
            return ALTERNATOR.alter( object );
        }
    }
    
    protected Object alterBack( Object object ) {
        if ( ALTERNATOR == null ) {
            return object;
        }
        else {
            return ALTERNATOR.alterBack( object );
        }
    }
    
    // Inner classes -----------------------------------------------------------
    
    public interface Alternator {
        
        public Object alter( Object object );
        
        public Object alterBack( Object object );
    }
    
    private class AlterIterator extends QueryIterator.Delegate {
        
        /** The object which will be returned as next */
        private Object next = null;
        
        AlterIterator() {
            super ( QUERY.iterator() );
        }
        
        public boolean hasNext() {
            return ITERATOR.hasNext();
        }
        
        public Object next() {
            
            Object next = ITERATOR.next();    
            return alter( next );
        }
    }
    
}
