/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.jmi.query;

import java.util.Iterator;
import java.util.NoSuchElementException;

/** Abstract class for creating filter queries.
 *
 * @author Petr Hrebejk
 */
public abstract class FilterQuery implements Query {

    private final Query QUERY;
    
    public FilterQuery( Query query ) {
        this.QUERY = query;
    }
    
    public Iterator iterator() {
        return new FilterIterator();
    }
    
    public boolean contains( Object object ) {
        return accept( object ) ? QUERY.contains( object ) : false;
    }
    
    abstract protected boolean accept( Object object );
    
    
    // Inner classes -----------------------------------------------------------
    
    private class FilterIterator extends QueryIterator.Delegate {
        
        /** The object which will be returned as next */
        private Object next = null;
        
        FilterIterator() {
            super ( QUERY.iterator() );
        }
        
        public boolean hasNext() {
            if ( !ITERATOR.hasNext() ) {
                return false;
            }
            else {
                return findNext();
            }
        }
        
        public Object next() {
            if ( next != null ) {
                return next;
            }
            else if ( findNext() ) {
                return next;
            }
            else {
                throw new NoSuchElementException();
            }
        }
        
        /** Finds next accepted element
        */
        private boolean findNext() {
            while( ITERATOR.hasNext() ) {
                Object object = ITERATOR.next();
                if ( accept( object ) ) {
                    next = object;
                    return true;
                }
            }
            
            next = null;
            return false;
        }
    }
}
