/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.jmi.query;

import java.util.Iterator;
import java.util.NoSuchElementException;

/** Takes two or more queries and makes an union of it. It *does not* 
 * remove duplicates.
 * 
 * @author Petr Hrebejk
 */
public class UnionQuery implements Query {

    Query[] queries;
    
    public UnionQuery( Query queryA, Query queryB ) {
        queries = new Query[] { queryA, queryB };
    }
    
    public UnionQuery(Query[] queries) {
        this.queries = queries;
    }
    
    public Iterator iterator() {
        return new UnionIterator( );
    }
    
    public boolean contains( Object object ) {
        
        for( int i = 0; i < queries.length; i++  ) {
            if ( queries[i].contains( object ) ) {
                return true;
            }
        }
        
        return false;
    }
    
    // Inner classes -----------------------------------------------------------
    
    private class UnionIterator extends QueryIterator {
        
        int index = 0;
        Iterator current = null; 
        
        UnionIterator( ) {
            super ();
            
            if ( queries.length > 0 ) {
                current = queries[0].iterator();
            }
        }
        
        public boolean hasNext() {
            
            if ( current == null ) {
                return false;
            }
            else if ( current.hasNext() ) {
                return true;
            }
            else {
                index++;
                if ( index >= queries.length ) {
                    current = null;
                    return false;
                }
                else {
                    current = queries[index].iterator();
                    return hasNext();
                }
            }
        }
        
        public Object next() {
            
            if ( current == null ) {
                throw new NoSuchElementException();
            }
            else if ( current.hasNext() ) {
                return current.next();
            }
            else {
                index++;
                if ( index >= queries.length ) {
                    current = null;
                    throw new NoSuchElementException();
                }
                else {
                    current = queries[index].iterator();
                    return next();
                }
            }
        }
    }
}
