/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.jmi.query;

import java.util.Comparator;

/** Filters all objects in Query which equals to value. Compers either bu equals()
 * or by comparator.
 *
 * @author Petr Hrebejk
 */
public class ValueFilter extends FilterQuery {

    private final Object VALUE;
    private final Comparator COMPARATOR;
    
    /** Only values for which value.equals( object ) == true are included 
    */
    public ValueFilter( Query query, Object value ) {
        this( query, value, null );
    }
    
    /** Includes objects for which the comaprator.comapre( value, object ) == 0
    */
    public ValueFilter( Query query, Object value, Comparator comparator ) {
        super( query );
        this.VALUE = value;
        this.COMPARATOR = comparator;
    }
    
    protected boolean accept( Object object ) {
        if ( COMPARATOR != null ) {
            return COMPARATOR.compare( VALUE, object ) == 0;
        }
        
        else {
            if ( VALUE == null ) {
                if ( object == null ) {
                    return true;
                }
                else {
                    return false;
                }
            }
            else {
                return VALUE.equals( object );
            }
        }
    }
    
}
