/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.jmi.xmi;

import java.util.Collection;
import java.io.OutputStream;
import java.io.IOException;
import javax.jmi.reflect.RefPackage;
import org.netbeans.api.xmi.XMIWriter;
import org.netbeans.api.xmi.XMIOutputConfig;

public class DelegatingWriter extends XMIWriter {

    public static final String XMI_VERSION_20 = "2.0";
    
    private XMIOutputConfig config;
    
    public DelegatingWriter () {
        config = new OutputConfig ();
    }
    
    public DelegatingWriter (XMIOutputConfig config) {
        this.config = config;
    }
    
    public XMIOutputConfig getConfiguration() {
        return config;
    }
    
    public void write(OutputStream stream, String uri, Collection objects, String xmiVersion) throws IOException {
        getWriter (xmiVersion).write (stream, uri, objects, xmiVersion);
    }

    public void write(OutputStream stream, String uri, RefPackage extent, String xmiVersion) throws IOException {
        getWriter (xmiVersion).write (stream, uri, extent, xmiVersion);
    }

    private WriterBase getWriter (String xmiVersion) {
        if ((xmiVersion != null) && (xmiVersion.equals (XMI_VERSION_20)))
            return new XMI20Writer (config);
        else
            return new WriterBase (config);
    }
    
}
