/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.jmi.xmi;

import org.netbeans.api.xmi.*;

public class InputConfig extends XMIInputConfig {
    
    private XMIReferenceResolver resolver = null;
    private XMIHeaderConsumer headerConsumer = null;
    private UnknownElementsListener unknownElemsListener = null;
    private boolean ignoreUnknownElements = false;
    
    public void setReferenceResolver(XMIReferenceResolver resolver) {
        this.resolver = resolver;
    }
        
    public XMIReferenceResolver getReferenceResolver() {
        return resolver;
    }
    
    // XMIHeaderConsumer ........................................................
    
    public void setHeaderConsumer(XMIHeaderConsumer consumer) {
        headerConsumer = consumer;
    }
        
    public XMIHeaderConsumer getHeaderConsumer() {
        return headerConsumer;
    }
    
    // ..........................................................................
    
    public boolean isUnknownElementsIgnored() {
        return ignoreUnknownElements;
    }
    
    public void setUnknownElementsIgnored(boolean newValue) {
        ignoreUnknownElements = newValue;
    }
    
    public UnknownElementsListener getUnknownElementsListener() {
        return unknownElemsListener;
    }
    
    public void setUnknownElementsListener(UnknownElementsListener listener) {
        unknownElemsListener = listener;
    }
    
}
