/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is Forte for Java, Community Edition. The Initial
 * Developer of the Original Software is Sun Microsystems, Inc. Portions
 * Copyright 1997-2006 Sun Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.mdrxml;

import org.xml.sax.*;

import java.util.*;
import java.io.*;

import org.openide.*;
import org.openide.filesystems.*;
import org.openide.loaders.*;
import org.openide.xml.*;
import org.openide.util.*;

//import org.netbeans.modules.xml.core.tree.ModuleEntityResolver;

import org.netbeans.api.mdr.*;
import xmlmodel.*;

import javax.jmi.reflect.RefPackage;
import javax.jmi.model.*;

/**
 * Simple MDR filler. Waring: It does not work for mixed content XML files.
 *
 * @author  Petr Kuzel
 */
public class FillRepositoryAction extends org.netbeans.modules.mdrxml.util.XMLToolsAction {
    
    private static final boolean DEBUG = false;
    
    // shortcuts
    xmlmodel.Contains contains;
    xmlmodel.TextNodeClass textNodeClass;
    xmlmodel.RootNodeClass rootNodeClass;
    xmlmodel.AttributeNodeClass attributeClass;
    xmlmodel.ElementNodeClass nodeClass;
    
    /** Creates a new instance of FillRepositoryAction */
    public FillRepositoryAction() {
    }
    
    public org.openide.util.HelpCtx getHelpCtx() {
        return null;
    }
    
    public String getName() {
        return "Fill MDRepository";
    }
    
    protected void performXMLAction(FileObject fo) {
        
//        EntityResolver resolver = (ModuleEntityResolver) Lookup.getDefault().lookup(ModuleEntityResolver.class);
        
        // create model
        
        // find repository implementation using MDRManager
        MDRepository repository = MDRManager.getDefault().getDefaultRepository();
        TopManager tm = TopManager.getDefault();
        
        // get package, fill classes
        XmlmodelPackage extent = (XmlmodelPackage) repository.getExtent(MDRXMLModule.XML_MODEL);
        contains = extent.getContains();
        textNodeClass = extent.getTextNode();
        rootNodeClass = extent.getRootNode();
        attributeClass = extent.getAttributeNode();
        nodeClass = extent.getElementNode();
        
        // put it into repository, how to specify where? an instance?        
        try {
            repository.beginTrans(true);
            tm.setStatusText ("XML parsing started.");
            
            String id = fo.getURL().toExternalForm();
            if (DEBUG) System.err.println("URL:" + id);
            ParserImpl impl = new ParserImpl(id);
            XMLReader reader = XMLUtil.createXMLReader();
//            reader.setEntityResolver(resolver);
            
            reader.setErrorHandler( new ErrorHandler() {  
                public void error(SAXParseException ex) throws SAXException {
                    throw ex;
                }
                public void warning(SAXParseException ex) throws SAXException {
                    throw ex;
                }
                
                public void fatalError(SAXParseException ex) throws SAXException {
                    throw ex;
                }
                
            });
            InputSource in = new InputSource(id);
            in.setByteStream(fo.getInputStream());
            reader.setContentHandler(impl);
            reader.parse(in);
        } catch (IOException ex) {
            //!!! handle somehow
            tm.notifyException(ex);
        } catch (SAXException ex) {
            //!!! handle somehow
            // it is user document error!
            tm.notifyException(ex);
        } finally { 
            repository.endTrans();
            tm.setStatusText ("XML parsing finished.");
        }
    }
    
    private class ParserImpl implements ContentHandler {
        
        private final StringBuffer content = new StringBuffer();
        private boolean root = true;
        private final Stack parents = new Stack();
        private final String name;
        
        public ParserImpl(String documentID) {
            name = documentID;
        }
        
        public void characters(char[] values, int offset, int len) throws org.xml.sax.SAXException {
            if (DEBUG) System.err.println("characters()");
            content.append(values, offset, len);
        }
        
        public void endDocument() throws org.xml.sax.SAXException {
        }

        public void startDocument() throws org.xml.sax.SAXException {
            parents.push(null);
        }
        
        public void startElement(String uri, String local, String qname, org.xml.sax.Attributes attrs) throws org.xml.sax.SAXException {
            
            if (DEBUG) System.err.println("startElement");
            
            String data = content.toString();
            content.setLength(0);
            ElementNode me = (ElementNode) parents.peek();
            if (data.trim().length() > 0) {
                Node text = textNodeClass.createTextNode(data);
                
                // create Contains: text, me
                contains.add(text, me);
            }
            
            // handle root node
            ElementNode node;
            if (root) {
                node = rootNodeClass.createRootNode(qname, name);
                root = false;
            } else {
                node = nodeClass.createElementNode(qname);
            }
            
            // fill attributes
            for (int i = 0; i<attrs.getLength(); i++) {
                String name = attrs.getQName(i);
                String val = attrs.getValue(i);
                xmlmodel.AttributeNode attr = attributeClass.createAttributeNode(name, val);
                contains.add(attr, node);
            }
            
            // note it as parent
            parents.push(node);
        }
        
        public void endElement(String str, String str1, String str2) throws org.xml.sax.SAXException {
            
            if (DEBUG) System.err.println("endElement");
            
            String data = content.toString();
            content.setLength(0);
            ElementNode me = (ElementNode) parents.pop();
            if (data.trim().length() > 0) {
                Node text = textNodeClass.createTextNode(data);
                
                // create Contains: text, me
                contains.add(text, me);
            }
            
            ElementNode parent = (ElementNode) parents.peek();
            if (parent != null) {
                // create Contains: me, parent
                contains.add(me, parent);
            }
        }
        
        public void endPrefixMapping(String str) throws org.xml.sax.SAXException {
        }
        
        public void ignorableWhitespace(char[] values, int param, int param2) throws org.xml.sax.SAXException {
        }
        
        public void processingInstruction(String str, String str1) throws org.xml.sax.SAXException {
        }
        
        public void setDocumentLocator(org.xml.sax.Locator locator) {
        }
        
        public void skippedEntity(String str) throws org.xml.sax.SAXException {
        }
                        
        public void startPrefixMapping(String str, String str1) throws org.xml.sax.SAXException {
        }
        
    }
}
