/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is Forte for Java, Community Edition. The Initial
 * Developer of the Original Software is Sun Microsystems, Inc. Portions
 * Copyright 1997-2006 Sun Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.mdrxml.looks;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import org.openide.nodes.*;
import org.openide.util.NbBundle;
import org.netbeans.api.looks.*;
import org.netbeans.spi.looks.*;
import xmlmodel.AttributeNode;

/**
 *
 * @author  Tomas Zezula
 */
public class AttributeNodeLook extends NodeLook {
    
    private static final String ICON = "org/netbeans/modules/mdrxml/resources/attributeNode";
    
    private static class ValueProperty extends PropertySupport.ReadWrite {
        
        private AttributeNode node;
        
        public ValueProperty (AttributeNode node) {
            super (NbBundle.getMessage(AttributeNodeLook.class,"TXT_Value"),String.class,NbBundle.getMessage(AttributeNodeLook.class,"TXT_Value"),NbBundle.getMessage(AttributeNodeLook.class,"TIP_Value"));
            this.node = node;
        }
        
        public Object getValue () {
            if (this.node != null)
                return this.node.getValue();
            else
                return null;
        }
        
        public void setValue (Object value) {
            if (value instanceof String && this.node != null)
                node.setValue ((String)value);
        }
    }
    
    /** Creates a new instance of AttributeNodeLook */
    public AttributeNodeLook() {
        super (NbBundle.getMessage (AttributeNodeLook.class, "TXT_AttributeNodeLook"));
    }
    
    public String iconBase (Look.NodeSubstitute substitute) {
        return ICON;
    }
    
    public Node.PropertySet[] getPropertySets (Look.NodeSubstitute substitute) {
        Node.PropertySet[] sets = super.getPropertySets (substitute);
        ((Sheet.Set)sets[0]).put ( new ValueProperty ((AttributeNode)substitute.getRepresentedObject()));
        return sets;
    }
    
    public Transferable clipboardCopy (Look.NodeSubstitute substitute) throws IOException {
        AttributeNode node = (AttributeNode) substitute.getRepresentedObject ();
        String str = node.getName () + " = " + node.getValue ();    //NOI18N
        return new StringSelection (str);
    }
    
}
