/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is Forte for Java, Community Edition. The Initial
 * Developer of the Original Software is Sun Microsystems, Inc. Portions
 * Copyright 1997-2006 Sun Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.mdrxml.looks;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.jmi.reflect.*;
import javax.jmi.model.*;
import org.openide.util.NbBundle;
import org.netbeans.api.looks.*;
import org.netbeans.spi.looks.*;
import org.netbeans.api.mdr.*;
import xmlmodel.XmlmodelPackage;
import xmlmodel.RootNodeClass;
import xmlmodel.RootNode;
import org.netbeans.modules.mdrxml.util.XMLModelEventTranslator;
import org.netbeans.modules.mdrxml.util.NodeEventTranslator;
/**
 *
 * @author  Tomas Zezula
 */
public class DocumentsLook extends DefaultLook {
    
    private static final String ICON = "org/netbeans/modules/mdrxml/resources/packageproxy";
    
    /** Creates a new instance of DocumentsLook */
    public DocumentsLook() {
        super (NbBundle.getMessage (DocumentsLook.class, "TXT_DocumentsLook"));
    }
    
    public Object attachTo (Look.NodeSubstitute substitute) {
        super.attachTo (substitute);
        XMLModelEventTranslator translator = XMLModelEventTranslator.addXMLPackage(substitute);
        return new NodeEventTranslator (translator,(RefBaseObject)substitute.getRepresentedObject(),substitute);
    }
    
    public String getName (Look.NodeSubstitute substitute) {
        RefPackage pkg = (RefPackage) substitute.getRepresentedObject ();
        MDRepository repo = ((MDRObject)pkg).repository();
        String[] names = repo.getExtentNames ();
        for (int i=0; i< names.length; i++) {
            if (repo.getExtent (names[i]).equals (pkg))
                return names[i];
        }
        return ((MofPackage)pkg.refMetaObject()).getName();
    }
    
    public String getDisplayName (Look.NodeSubstitute substitute) {
        return this.getName (substitute);
    }
    
    public String iconBase (Look.NodeSubstitute substitute) {
        return ICON;
    }
    
    public Object[] getChildObjects (Look.NodeSubstitute substitute) {
        XmlmodelPackage pkg = (XmlmodelPackage) substitute.getRepresentedObject ();
        MDRepository repo = ((MDRObject)pkg).repository ();
        repo.beginTrans (false);
        try {
            RootNodeClass rnClass = pkg.getRootNode ();
            Collection rootNodes = rnClass.refAllOfClass ();
            Object[] result = new Object [rootNodes.size()];
            Iterator it = rootNodes.iterator ();
            for (int i=0; it.hasNext(); i++) {
                result[i] = it.next();
            }
            return result;
        }finally {
            repo.endTrans ();
        }
    }
    
    public Transferable clipboardCopy (Look.NodeSubstitute substitute) throws IOException {
        return new StringSelection (this.getName(substitute));
    }
    
    public boolean canCopy (Look.NodeSubstitute substitute) {
        return true;
    }
    
}
