/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is Forte for Java, Community Edition. The Initial
 * Developer of the Original Software is Sun Microsystems, Inc. Portions
 * Copyright 1997-2006 Sun Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.mdrxml.looks;

import java.lang.ref.WeakReference;
import java.io.IOException;
import java.awt.datatransfer.Transferable;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.*;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.netbeans.api.looks.*;
import org.netbeans.spi.looks.*;
import org.netbeans.modules.mdrxml.looks.actions.DeleteAction;
import org.netbeans.modules.mdrxml.looks.actions.GenerateTextAction;
/**
 *
 * @author  Tomas Zezula
 */
public class NodeLook extends DefaultLook {
    
    private static class NameProperty extends PropertySupport.ReadWrite {
        
        private WeakReference ref;
        
        public NameProperty(Look.NodeSubstitute substitute) {
            super(NbBundle.getMessage(NodeLook.class,"TXT_Name"),String.class,NbBundle.getMessage(NodeLook.class,"TXT_Name"),NbBundle.getMessage(NodeLook.class,"TIP_Name"));
            this.ref = new WeakReference (substitute);
        }
        
        public Object getValue() {
	    Look.NodeSubstitute val = (Look.NodeSubstitute) this.ref.get ();
            if (val != null && (val.getRepresentedObject() instanceof xmlmodel.Node)) {
                return ((xmlmodel.Node)val.getRepresentedObject()).getName();
            }
            else {
                return null;
            }
        }
        
        public void setValue(Object value) {
	    Look.NodeSubstitute val = (Look.NodeSubstitute) this.ref.get ();
            if (value instanceof String && val != null && val.getRepresentedObject() instanceof xmlmodel.Node) {
                ((xmlmodel.Node)val.getRepresentedObject()).setName((String)value);
                val.fireNameChange(null,(String)value);
                val.fireDisplayNameChange(null,(String)value);
            }
        }
        
    }
    
    /** Creates a new instance of NodeLook */
    public NodeLook(String name) {
        super(name);
    }
    
    public String getName(Look.NodeSubstitute substitute) {
        try {
            xmlmodel.Node en = (xmlmodel.Node) substitute.getRepresentedObject();
            return en.getName();
        }catch (javax.jmi.reflect.InvalidObjectException ioe) {
            return new String ();
        }
    }
    
    public String getDisplayName(Look.NodeSubstitute substitute) {
        return this.getName(substitute);
    }
    
    public Node.PropertySet[] getPropertySets(Look.NodeSubstitute substitute) {
        Sheet.Set set = new Sheet.Set();
        String name = NbBundle.getMessage(NodeLook.class,"TXT_Properties");
        set.setName(name);
        set.setDisplayName(name);
        set.put(new NameProperty(substitute));
        return new Node.PropertySet[] {set};
    }
    
    public javax.swing.Action[] getActions(Look.NodeSubstitute substitute) {
        return new javax.swing.Action[] {
            SystemAction.get(DeleteAction.class),
            SystemAction.get(PropertiesAction.class),
            SystemAction.get(GenerateTextAction.class)
        };
    }
    
    public boolean canCopy (Look.NodeSubstitute substitute) {
      return true;  
    }
    
    public Transferable drag (Look.NodeSubstitute substitute) throws IOException {
        return this.clipboardCopy (substitute);
    }
    
}
