/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is Forte for Java, Community Edition. The Initial
 * Developer of the Original Software is Sun Microsystems, Inc. Portions
 * Copyright 1997-2006 Sun Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.mdrxml.looks;

import java.util.Collection;
import java.util.Iterator;
import org.openide.nodes.*;
import org.openide.util.NbBundle;
import org.netbeans.api.looks.*;
import org.netbeans.spi.looks.*;
import org.netbeans.api.mdr.*;
import xmlmodel.RootNode;
/**
 *
 * @author  Tomas Zezula
 */
public class RootNodeLook extends ElementNodeLook {
    
    private static final String ICON = "org/netbeans/modules/mdrxml/resources/rootNode";
    
    private static class DocumentNameProperty extends PropertySupport.ReadOnly {
        
        private RootNode node;
        
        public DocumentNameProperty (RootNode node) {
            super (NbBundle.getMessage(RootNodeLook.class,"TXT_DocumentName"),String.class,NbBundle.getMessage(RootNodeLook.class,"TXT_DocumentName"),NbBundle.getMessage(RootNodeLook.class,"TIP_DocumentName"));
            this.node = node;
        }
        
        public Object getValue () {
            if (this.node != null)
                return this.node.getDocumentName ();
            else
                return null;
        }
    }
    
    /** Creates a new instance of RootNodeLook */
    public RootNodeLook() {
        super (NbBundle.getMessage (RootNodeLook.class, "TXT_RootNodeLook"));
    }
    
    public String iconBase (Look.NodeSubstitute substitute) {
        return ICON;
    }
    
    public Node.PropertySet[] getPropertySets (Look.NodeSubstitute substitute) {
        Node.PropertySet[] sets = super.getPropertySets (substitute);
        ((Sheet.Set)sets[0]).put (new DocumentNameProperty ((RootNode)substitute.getRepresentedObject()));
        return sets;
    }
    
}
