/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is Forte for Java, Community Edition. The Initial
 * Developer of the Original Software is Sun Microsystems, Inc. Portions
 * Copyright 1997-2006 Sun Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.mdrxml.looks;

import java.util.Collection;
import java.util.Iterator;
import org.netbeans.api.looks.*;
import org.netbeans.spi.looks.*;
import org.netbeans.api.mdr.*;
import org.openide.util.NbBundle;
import xmlmodel.TextNode;
/**
 *
 * @author  Tomas Zezula
 */
public class TextNodeLook extends ElementNodeLook {
    
    private static final String ICON = "org/netbeans/modules/mdrxml/resources/textNode";
    
    
    /** Creates a new instance of TextNodeLook */
    public TextNodeLook() {
        super(NbBundle.getMessage(TextNodeLook.class, "TXT_TextNodeLook"));
    }
    
    /** Overrides NodeLook.getName to truncate the
     *  string, if its lengt is greater than 20 chars.
     */
    public String getName(Look.NodeSubstitute substitute) {
        try {
            String result = ((TextNode)substitute.getRepresentedObject()).getName();
            if (result == null)
                result = "";    // NoI18N
            if (result.length() > 20)
                result = result.substring(0,20)+ "...";
            return result;
        }catch (javax.jmi.reflect.InvalidObjectException ioe) {
            return new String();
        }
    }
    
    public String iconBase(Look.NodeSubstitute substitute) {
        return ICON;
    }
    
}
