/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is Forte for Java, Community Edition. The Initial
 * Developer of the Original Software is Sun Microsystems, Inc. Portions
 * Copyright 1997-2006 Sun Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.mdrxml.looks.actions;

import java.util.Collection;
import java.util.Iterator;
import javax.jmi.reflect.*;
import org.openide.nodes.*;
import org.openide.util.actions.NodeAction;
import org.openide.util.NbBundle;
import org.openide.util.HelpCtx;
import org.netbeans.api.looks.*;
import org.netbeans.api.mdr.MDRObject;
import org.netbeans.api.mdr.MDRepository;
/**
 *
 * @author  Tomas Zezula
 */
public class DeleteAction extends NodeAction {
    
    /** Creates a new instance of DeleteAction */
    public DeleteAction() {
    }
    
    public void performAction(Node[] nodes) {
        for (int i=0; i< nodes.length; i++) {
            LookNode ln = (LookNode) nodes[i];
            xmlmodel.Node node = (xmlmodel.Node) ln.getRepresentedObject();
            MDRepository repo = ((MDRObject)node).repository();
            repo.beginTrans(true);
            try {
                if (node instanceof xmlmodel.ElementNode)
                    this.deleteHierarchy ((xmlmodel.ElementNode)node);
                ((RefObject)node).refDelete();
            }catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                repo.endTrans();
            }
        }
    }
    
    public boolean enable(Node[] nodes) {
        if (nodes == null)
            return false;
        for (int i=0; i< nodes.length; i++) {
            if (!(nodes[i] instanceof LookNode))
                return false;
            if (!(((LookNode)nodes[i]).getRepresentedObject() instanceof xmlmodel.Node))
                return false;
        }
        return true;
    }
    
    public String getName() {
        return NbBundle.getMessage(DeleteAction.class, "TXT_Delete");
    }
    
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
    
    
    protected void deleteHierarchy(xmlmodel.ElementNode node) {
        Collection subNodes = node.getNodes();
        for (Iterator it = subNodes.iterator(); it.hasNext();) {
            xmlmodel.Node subNode = (xmlmodel.Node)it.next();
	    it.remove ();
            if (subNode instanceof xmlmodel.ElementNode)
                deleteHierarchy ((xmlmodel.ElementNode)subNode);
	    if (subNode != null)
		try {
        	 ((RefObject)subNode).refDelete();
		} catch (javax.jmi.reflect.InvalidObjectException invalidObjectExc) {
		    // Already deleted object
		}
        }
    }
}
