/*
 * GenerateTextAction.java
 *
 * Created on July 25, 2002, 6:21 PM
 */

package org.netbeans.modules.mdrxml.looks.actions;


import org.openide.TopManager;
import org.openide.nodes.Node;
import org.openide.util.actions.NodeAction;
import org.openide.util.NbBundle;
import org.openide.util.HelpCtx;
import org.netbeans.api.looks.LookNode;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import xmlmodel.*;
/**
 *
 * @author  xtom
 */
public class GenerateTextAction extends NodeAction {
    
    private static final String INDENT = "  ";  	//NOI18N
    private static final String NL = "\n";		//NOI18N
    private static final String TXT_EXT = ".txt";	//NOI18N
    
    /** Creates a new instance of GenerateTextAction */
    public GenerateTextAction() {
    }
    
    
    public void performAction (Node[] nodes) {
        xmlmodel.Node node = (xmlmodel.Node) ((LookNode)nodes[0]).getRepresentedObject();
        JFileChooser fc = new JFileChooser ();
        fc.setFileFilter(new TextFileFilter ());
        if (fc.showOpenDialog(TopManager.getDefault().getWindowManager().getMainWindow()) == JFileChooser.APPROVE_OPTION) {
            File file = fc.getSelectedFile ();
            PrintWriter pw = null;
            try {
                pw = new PrintWriter ( new FileWriter (file));
                String result = processNode (node,0);
                pw.println (result);
            }catch (IOException ioe) {
                TopManager.getDefault().notifyException (ioe);
            }
            finally {
		if (pw != null)
                    pw.close();
            }
            
        }
    }
    
    public boolean enable (Node[] nodes) {
        if (nodes == null || nodes.length != 1 || (!(nodes[0] instanceof LookNode)))
            return false;
        return (((LookNode)nodes[0]).getRepresentedObject () instanceof xmlmodel.Node);
    }
    
    public HelpCtx getHelpCtx () {
        return HelpCtx.DEFAULT_HELP;
    }
    
    public String getName () {
        return NbBundle.getMessage (GenerateTextAction.class,"TXT_GenerateTXT");
    }
    
    
    private static String processNode (xmlmodel.Node node, int indent) {
        String result = generateFill (indent) + node.getName () + NL;
        if (node instanceof xmlmodel.ElementNode) {
            for (Iterator it = ((xmlmodel.ElementNode)node).getNodes().iterator(); it.hasNext();) {
                result = result + processNode ((xmlmodel.Node)it.next(), indent+1);
            }
        }
	return result;
    }
    
    private static String generateFill (int count) {
        StringBuffer sb = new StringBuffer ();
        for (int i=0; i< count; i++)
            sb.append (INDENT);
        return sb.toString ();
    }
    
    
    private static class TextFileFilter extends FileFilter {
    
	public boolean accept (File file) {
	    return (file.isDirectory() || file.getName().toUpperCase().endsWith (TXT_EXT));
	}
	
	public String getDescription () {
	    return NbBundle.getMessage (GenerateTextAction.class, "TXT_TXT");
	}
    }
    
}
