/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.mdrxml.looks.actions;

import org.openide.util.NbBundle;
import org.openide.TopManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.*;
import org.openide.util.actions.NodeAction;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileObject;
import org.openide.loaders.*;

import org.netbeans.api.looks.*;
import org.netbeans.api.mdr.*;
import org.netbeans.modules.mdrxml.util.XMLGenerator;

import javax.jmi.reflect.*;
import xmlmodel.*;
import java.util.*;
import java.io.*;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class GenerateXMLAction extends NodeAction {
    
    private static ResourceBundle bundle;

    protected void performAction (Node[] nodes) {
        Node node = nodes[0];
        LookNode lookNode = (LookNode) node;
        if ( lookNode != null ) {
            generateXML( lookNode );
        }
    }

    private void generateXML( LookNode lookNode ) {
        File temp = null;
        final TopManager tm = TopManager.getDefault();
        // selects one folder from data systems
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new XMLFileFilter());
	java.awt.Component parent = tm.getWindowManager().getMainWindow();
        int returnVal = org.openide.util.Utilities.showJFileChooser(chooser, parent, getLocalizedString("TXT_GenerateXML"));
        if(returnVal == JFileChooser.APPROVE_OPTION) {
            temp = chooser.getSelectedFile();
        }
        
        final File file = temp;
        final ElementNode elementNode = (ElementNode) lookNode.getRepresentedObject();
        
        if (file != null) {
            RequestProcessor.postRequest(new Runnable() {
                public void run() {                    
                    tm.setStatusText (getLocalizedString("TXT_StartGenerate"));
                    try {
                        FileOutputStream fos = new FileOutputStream( file );
                        new XMLGenerator ().generateXML (fos, elementNode);
                        tm.setStatusText (getLocalizedString("TXT_FinishGeneration"));
                    } catch (Exception e) {
                        TopManager.getDefault().getErrorManager().notify (e);
                    }
                } // run
            });
        } // if
    }
    
    private static String getLocalizedString (String message) {
        if (bundle == null)
            bundle = NbBundle.getBundle (GenerateXMLAction.class);
        return bundle.getString (message);
    }

    protected boolean enable (Node[] nodes) {
        if (nodes.length != 1)
            return false;
        if (!(nodes[0] instanceof LookNode))
            return false;
        LookNode lookNode = (LookNode) nodes[0];
        return lookNode.getRepresentedObject() instanceof ElementNode;
    }

    public String getName () {
        return getLocalizedString ("TXT_GenerateAction");
    }

    protected String iconResource () {
        return null;
    }

    public HelpCtx getHelpCtx () {
        return HelpCtx.DEFAULT_HELP;
    }

    private static final class XMLFileFilter extends FileFilter {
        public boolean accept(File f) {
            return f.getName().toUpperCase().endsWith(".XML") || f.isDirectory(); // No I18N
        }
        
        public String getDescription() {
            return getLocalizedString ("TXT_XMLFiles");
        }
    }
        
}