/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is Forte for Java, Community Edition. The Initial
 * Developer of the Original Software is Sun Microsystems, Inc. Portions
 * Copyright 1997-2006 Sun Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.mdrxml.looks.actions;


import java.util.ResourceBundle;
import javax.jmi.reflect.RefObject;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.nodes.*;
import org.openide.util.actions.NodeAction;
import org.openide.util.NbBundle;
import org.openide.util.HelpCtx;
import org.netbeans.api.looks.*;
import xmlmodel.TextNode;
import xmlmodel.ElementNode;
/**
 *
 * @author  Tomas Zezula
 */
public class NewAction extends NodeAction {
    
    private static final String ELEMENT = "ELEMENT";    // NoI18N
    private static final String TEXT = "TEXT";  //NoI18N
    private static final String ATTRIBUTE = "ATTR"; // NoI18N
    
    private static ResourceBundle bundle;
    private String source;
    
    /** Creates a new instance of NewAction */
    public NewAction() {
    }
    
    public void performAction(Node[] nodes) {
        xmlmodel.ElementNode node = (xmlmodel.ElementNode) ((LookNode)nodes[0]).getRepresentedObject();
        if (this.source.equals(ELEMENT)) {
            this.newElementNode(node);
        }
        else if (this.source.equals (ATTRIBUTE)) {
            this.newAttributeNode(node);
        }
        else if (this.source.equals(TEXT)) {
            this.newTextNode(node);
        }
    }
    
    public void actionPerformed(java.awt.event.ActionEvent event) {
        this.source = event.getActionCommand();
        super.actionPerformed(event);
    }
    
    public JMenuItem getPopupPresenter() {
        
        if (this.isEnabled()) {
            JMenu presenter = new JMenu(getLocalizedString("TXT_NewAction"));
            JMenuItem mi = new JMenuItem();
            mi.setLabel(getLocalizedString("TXT_Element"));
            mi.addActionListener(this);
            mi.setActionCommand(ELEMENT);
            presenter.add(mi);
            mi = new JMenuItem();
            mi.setLabel(getLocalizedString("TXT_Attribute"));
            mi.addActionListener(this);
            mi.setActionCommand(ATTRIBUTE);
            presenter.add(mi);
            mi = new JMenuItem();
            mi.setLabel(getLocalizedString("TXT_Text"));
            mi.addActionListener(this);
            mi.setActionCommand(TEXT);
            presenter.add(mi);
            return presenter;
        }
        else {
            JMenuItem presenter = new JMenuItem (getLocalizedString("TXT_NewAction"));
            presenter.setEnabled (false);
            return presenter;
        }
    }
    
    public boolean enable(Node[] nodes) {
        if (nodes == null || nodes.length != 1 || !(nodes[0] instanceof LookNode))
            return false;
        return (((LookNode)nodes[0]).getRepresentedObject() instanceof ElementNode) &&
        ! (((LookNode)nodes[0]).getRepresentedObject() instanceof TextNode);
    }
    
    public String getName() {
        return getLocalizedString("TXT_NewAction");
    }
    
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
    
    protected static String getLocalizedString(String msg) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(NewAction.class);
        }
        return bundle.getString(msg);
    }
    
    protected void newElementNode(xmlmodel.ElementNode en) {
        NotifyDescriptor.InputLine dd = new NotifyDescriptor.InputLine(getLocalizedString("TXT_ElementName"), getLocalizedString("TXT_NewElement"));
        if (TopManager.getDefault().notify(dd) == DialogDescriptor.OK_OPTION) {
            String name = dd.getInputText();
            xmlmodel.XmlmodelPackage pkg = (xmlmodel.XmlmodelPackage) ((RefObject)en).refImmediatePackage();
            en.getNodes().add(pkg.getElementNode().createElementNode(name));
        }
    }
    
    protected void newTextNode(xmlmodel.ElementNode en) {
        NewTextPanel ntp = new NewTextPanel();
        DialogDescriptor dd = new DialogDescriptor(ntp, getLocalizedString("TXT_NewText"));
        java.awt.Dialog dlg = TopManager.getDefault().createDialog(dd);
        dlg.setVisible(true);
        if (dd.getValue() == DialogDescriptor.OK_OPTION) {
            String name = ntp.getText();
            xmlmodel.XmlmodelPackage pkg = (xmlmodel.XmlmodelPackage) ((RefObject)en).refImmediatePackage();
            en.getNodes().add(pkg.getTextNode().createTextNode(name));
        }
    }
    
    protected void newAttributeNode(xmlmodel.ElementNode en) {
        NewAttributePanel nap = new NewAttributePanel();
        DialogDescriptor dd = new DialogDescriptor(nap, NbBundle.getMessage (NewAction.class,"TXT_NewAttribute"));
        java.awt.Dialog dlg = TopManager.getDefault().createDialog(dd);
        dlg.setVisible(true);
        if (dd.getValue() == DialogDescriptor.OK_OPTION) {
            String attrName = nap.getAttributeName();
            String attrValue = nap.getAttributeValue();
            xmlmodel.XmlmodelPackage pkg = (xmlmodel.XmlmodelPackage) ((RefObject)en).refImmediatePackage();
            en.getNodes().add(pkg.getAttributeNode().createAttributeNode(attrName,attrValue));
        }
    }
    
}
