/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is Forte for Java, Community Edition. The Initial
 * Developer of the Original Software is Sun Microsystems, Inc. Portions
 * Copyright 1997-2006 Sun Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.mdrxml.util;

/**
 *
 * @author  Tomas Zezula
 */
import java.lang.ref.*;
import java.util.HashMap;
import java.util.Iterator;
import javax.jmi.reflect.*;
import org.openide.util.RequestProcessor;
import org.netbeans.api.looks.*;
import org.netbeans.spi.looks.*;
import org.netbeans.api.mdr.*;
import org.netbeans.api.mdr.events.*;
import xmlmodel.*;

public class XMLModelEventTranslator implements MDRPreChangeListener {
    
    private static HashMap xmlPackages;
    private static final int DELAY = 60000;
    
    protected XmlmodelPackage xmlPkg;
    protected HashMap contexts = new HashMap();
    protected HashMap registeredNodes = new HashMap();
    

    private XMLModelEventTranslator(XmlmodelPackage xmlPkg) {
        this.xmlPkg = xmlPkg;
        ((MDRChangeSource)this.xmlPkg).addListener(this);
    }
    
    void addNodeSubstitute(NodeEventTranslator t) {
        this.addNodeSubstitute((RefBaseObject)((Look.NodeSubstitute)t.get()).getRepresentedObject(), t);
    }
    
    void addNodeSubstitute(RefBaseObject key, NodeEventTranslator t) {
        this.registeredNodes.put(key.refMofId(), t);
    }
    
    void removeNodeSubstitute(RefBaseObject key, NodeEventTranslator t) {
        String id = key.refMofId();
        if (registeredNodes.get (id) == t) {
            this.registeredNodes.remove (id);
        }
    }
    
    public synchronized void plannedChange(MDRChangeEvent event) {
        if ((event.getType() & InstanceEvent.EVENT_INSTANCE_DELETE) == InstanceEvent.EVENT_INSTANCE_DELETE) {
            Node node = (Node) event.getSource();
            RefBaseObject affectedObject = node.getParentNode();
            if (affectedObject == null && (node instanceof RootNode))
                affectedObject = this.xmlPkg;
            Look.NodeSubstitute affectedSubstitute = this.getNodeSubstitute(affectedObject);
            if (affectedSubstitute != null) {
                this.contexts.put(event.getSource(), affectedSubstitute);
            }
        }
    }
    
    public void changeCancelled(MDRChangeEvent event) {
        this.contexts.remove(event.getSource());
    }
    
    public void change(MDRChangeEvent event) {
        Look.NodeSubstitute affectedSubstitute = null;
        if ((event.getType() & InstanceEvent.EVENT_INSTANCE_DELETE) == InstanceEvent.EVENT_INSTANCE_DELETE) {
            affectedSubstitute = (Look.NodeSubstitute) this.contexts.remove(event.getSource());
        }
        else if ((event.getType() & InstanceEvent.EVENT_INSTANCE_CREATE) == InstanceEvent.EVENT_INSTANCE_CREATE) {
            Node node = (Node) ((InstanceEvent)event).getInstance();
            RefBaseObject parent = node.getParentNode();
            if (parent == null && node instanceof RootNode)
                parent = this.xmlPkg;
            affectedSubstitute = this.getNodeSubstitute(parent);
        }
        else if ((event.getType() & AssociationEvent.EVENT_ASSOCIATION_ADD) == AssociationEvent.EVENT_ASSOCIATION_ADD) {
            affectedSubstitute = this.getNodeSubstitute(((AssociationEvent)event).getFixedElement());
        }
        
        if (affectedSubstitute != null)
            affectedSubstitute.refreshChildren();
    }
    
    private synchronized Look.NodeSubstitute getNodeSubstitute(RefBaseObject key) {
        if (key == null)
            return null;
        Reference ref = (Reference) this.registeredNodes.get(key.refMofId());
        if (ref == null)
            return null;
        Look.NodeSubstitute substitute = (Look.NodeSubstitute) ref.get();
        if (substitute == null) {
            this.registeredNodes.remove(key.refMofId());
        }
        return substitute;
    }
    
    
    public static XMLModelEventTranslator getTranslator(XmlmodelPackage pkg) {
        Reference ref = (Reference) xmlPackages.get(pkg);
        if (ref == null)
            return null;
        return (XMLModelEventTranslator) ref.get();
    }
    
    public static XMLModelEventTranslator addXMLPackage(Look.NodeSubstitute substitute) {
        if (substitute == null || !(substitute.getRepresentedObject() instanceof XmlmodelPackage))
            return null;
        if (xmlPackages == null) {
            xmlPackages = new HashMap(5);
            RequestProcessor.postRequest(new CleanerTask(),DELAY);
        }
        XMLModelEventTranslator translator = null;
        XmlmodelPackage pkg = (XmlmodelPackage) substitute.getRepresentedObject();
        WeakReference ref = (WeakReference) xmlPackages.get(pkg);
        if (ref != null) {
            translator = (XMLModelEventTranslator) ref.get();
            if (translator != null)
                return translator;
        }
        translator = new XMLModelEventTranslator(pkg);
        synchronized (xmlPackages) {
            xmlPackages.put(pkg, new WeakReference(translator));
        }
        return translator;
    }
    
    
    private static class CleanerTask implements Runnable {
        public void run() {
                synchronized (xmlPackages) {
                    Iterator it = xmlPackages.values().iterator();
                    while (it.hasNext()) {
                        Reference ref = (Reference) it.next();
                        XMLModelEventTranslator et = (XMLModelEventTranslator) ref.get();
                        if (et == null) {
                            it.remove();
                        }
                        else if (et.registeredNodes.size() == 0) {
                            ((MDRChangeSource)et.xmlPkg).removeListener (et);
                            it.remove ();
                        }
                    }
                }
            RequestProcessor.postRequest(this,DELAY);
        }
    }
    
}
