/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is Forte for Java, Community Edition. The Initial
 * Developer of the Original Software is Sun Microsystems, Inc. Portions
 * Copyright 1997-2006 Sun Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.mdrxml.util;

import org.openide.util.actions.*;
import org.openide.nodes.*;
import org.openide.filesystems.*;
import org.openide.loaders.*;

/**
 * Abstract action enabled on XML resources. Subclass should overide
 * <code>performXMLAction()</code> to fullfil desired contact.
 *
 * @author  Petr Kuzel
 */
public abstract class XMLToolsAction extends NodeAction {
    
    /** Creates a new instance of FillRepositoryAction */
    public XMLToolsAction() {
    }

    /*
     * @return true if one XML file backgrounded file is selected.
     */
    protected boolean enable(Node nodes[]) {
        if (nodes != null && nodes.length == 1) {
            DataObject dobj = (DataObject) nodes[0].getCookie(DataObject.class);
            if (dobj != null) {
                if (dobj instanceof XMLDataObject) return true;
                
                FileObject fo = dobj.getPrimaryFile();
                if (fo.getMIMEType().endsWith("+xml")) return true;
            }
        }
        return false;
    }
        
    protected abstract void performXMLAction(FileObject fo);
    
    protected void performAction(Node[] nodes) {
        if (nodes != null && nodes.length == 1) {
            DataObject dobj = (DataObject) nodes[0].getCookie(DataObject.class);
            if (dobj != null) {
                performXMLAction(dobj.getPrimaryFile());
            }
        }
    }
    
}
