/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdrshell;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

import java.util.Collection;
import java.util.ArrayList;
import java.util.Iterator;

import org.netbeans.api.mdr.*;
import org.openide.util.*;

import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.mdr.util.*;

import javax.jmi.model.ModelPackage;
import javax.jmi.model.Import;
import javax.jmi.model.ImportClass;
import javax.jmi.model.ModelElement;
import javax.jmi.reflect.*;
import org.netbeans.mdr.persistence.memoryimpl.StorageFactoryImpl;
import org.openide.ErrorManager;

public class Main extends Object {
    
    /**
     * Resources names of the standard library files
     */
    public static String[] STANDARD_LIBS = new String[] { "resources/start.ms", "resources/ext.ms" };
    
    /**
     *  Command line interface of the MDRShell. The MDRShell is a
     *  <em>Dynamic Java</em> shell with preprocessor. Before user input
     *  is processed the files <code>start.ms</code> and <code>ext.ms</code>
     *  in the package <code>org.netbeans.mdr.shell.resources</code> and the
     *  files given as command line arguments are processed.
     *
     *  @param args a list of file names read into the shell
     *  @throws FileNotFoundException if one of the arguments does not denote a
     *                         valid file name
     *  @throws SecurityException if there is no read access to a file given as
     *                          argument
     */
    public static void main( String[] args ) throws FileNotFoundException {
        try {
            /* the input streams */
            InputStream[] iss = new InputStream[STANDARD_LIBS.length+args.length+1];

            /* standard library files */
            for ( int i=0; i<STANDARD_LIBS.length; i++ ) {
                iss[i] = Main.class.getResourceAsStream(STANDARD_LIBS[i]);
            }
            /* files given as arguments */
            for ( int i=0; i<args.length; i++ ) {
                iss[STANDARD_LIBS.length+i] = new FileInputStream(args[i]);
            }
            /* System.in for user input */
            iss[STANDARD_LIBS.length+args.length] = System.in;

            // Create and run the shell

            new Shell().run( iss );
            MDRManager.getDefault().shutdownAll();
        } catch (RuntimeException e) {
            ErrorManager.getDefault().notify(ErrorManager.EXCEPTION, e);
            //throw e;
        }
    }
}
