/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdrshell;

import java.util.Collection;
import java.util.Iterator;
import java.io.PrintStream;

/** Helper singleton for StringBuffer
 *
 * @author  Petr Hrebejk        
 * @version 
 */

class Support {

    /** Support is a singleton.
    */
    private Support() {
    }
    
    /** Aligns the StringBuffer to length given by position
    */
    public static void ensurePosition( StringBuffer sb, int position ) {

        if ( sb.length() < position ) {
            
            while ( sb.length() < position ) {
                sb.append( " " );
            }
        }
        else if ( sb.length() > position ) {
            sb.setLength( position );
        }
    }
    
    
    /** Default print function for results of commands. 
    */
    public static void defaultPrint( PrintStream ps, Object object ) {
        defaultPrint( ps, 0, object );
    }
    
    /** Default print function for results of commands at given position on
    * line.
    */
    public static void defaultPrint( PrintStream ps, int offset, Object object ) {
        
        if ( object == null ) {
            ps.println("null");
            return;
        }

        if ( object instanceof java.util.Iterator ) {
            printIndent( ps, offset );
            ps.print( "ITERATOR : {" );
            for( Iterator it = (Iterator)object; it.hasNext(); ) {
                defaultPrint( ps, offset + 2, it.next() );
            }
            ps.println();
            printIndent( ps, offset );
            ps.println( "} // end of ITERATOR" );
        }
        else if ( object.getClass().isArray() ) {
            printIndent( ps, offset );
            ps.print( "ARRAY : [" );
            for ( int i = 0; i < java.lang.reflect.Array.getLength( object ); i++ ) {
                //printIndent( ps, offset );
                defaultPrint( ps, offset + 2, java.lang.reflect.Array.get( object, i ) );
                //ps.println( java.lang.reflect.Array.get( object, i ).toString() );
            }
            ps.println();
            printIndent( ps, offset );
            ps.println( "] // end of ARRAY" );    
        }
        else if ( object instanceof Throwable ) {
            ((Throwable)object).printStackTrace();
        }
        else if ( object instanceof Collection  ) {
            printIndent( ps, offset );
            ps.print( "COLLECTION : {" );
            for( Iterator it = ((Collection)object).iterator(); it.hasNext(); ) {
                defaultPrint( ps, offset + 2, it.next() );
            }
            ps.println();
            printIndent( ps, offset );
            ps.println( "} // end of COLLECTION" );
        }
        else {
            printIndent( ps, offset );
            ps.println( object.toString() );
        }
        
    }

    
    private static void printIndent( PrintStream ps, int indent ) {
        for( ; indent > 0; indent -- ) {
            ps.print( " " );
        }
    }
    
}
