/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmiimpl.mof.model;

import java.util.*;
import javax.jmi.model.*;
import javax.jmi.reflect.*;

import org.netbeans.mdr.handlers.InstanceHandler;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.mdr.util.*;


/**
 * Implements MOF operations
 *
 * @author Martin Matula
 */
public abstract class AssociationEndImpl extends ModelElementImpl implements AssociationEnd {
    protected AssociationEndImpl(StorableObject storable) {
        super(storable);
    }

    public AssociationEnd otherEnd() {
        _lock(false);
        try {
            Namespace container = this.getContainer();
            if (container == null) return null;
            Collection elements = container.getContents();
            Object element;

            for (Iterator it = elements.iterator(); it.hasNext();) {
                element = it.next();
                if (element instanceof AssociationEnd && !element.equals(this)) {
                    return (AssociationEnd) element;
                }
            }

            return null;
        } finally {
            _unlock();
        }
    }

    // --- derived attributes

}
