/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmiimpl.mof.model;

import java.util.*;

import javax.jmi.model.*;
import javax.jmi.reflect.*;

import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.handlers.AssociationHandler;
import org.netbeans.mdr.handlers.IndexSetWrapper;
import org.netbeans.mdr.storagemodel.AssociationLink;
import org.netbeans.mdr.storagemodel.StorableAssociation;
import org.netbeans.mdr.storagemodel.StorableObject;

/** Implementation of DependsOn association which is derived in the MOF model.
 *
 * @author Martin Matula
 * @version 
 */
public abstract class DependsOnImpl extends AssociationHandler implements DependsOn {

    /** Creates new DependsOnImpl */
    protected DependsOnImpl(StorableAssociation storable) {
        super(storable);
    }

    // [PENDING] should be probably live
    public Collection refAllLinks() {
        HashSet allLinks = new HashSet();
        ModelElement dependent;
        
        for (Iterator it = ((ModelPackage) refImmediatePackage()).getModelElement().refAllOfType().iterator(); it.hasNext();) {
            dependent = (ModelElement) it.next();
            for (Iterator it2 = dependent.findRequiredElements(ModelElementImpl.ALL_KINDS, true).iterator(); it2.hasNext();) {
                allLinks.add(new AssociationLink((StorableObject) ((BaseObjectHandler) dependent)._getDelegate(), (StorableObject) ((BaseObjectHandler) it2.next())._getDelegate()));
            }
        }

        return new IndexSetWrapper(_getMdrStorage(), allLinks);
    }

    public boolean exists(ModelElement dependent, ModelElement provider) {
        return dependent.isRequiredBecause(provider, new String[1]);
    }

    public Collection getProvider(ModelElement dependent) {
        return dependent.findRequiredElements(ModelElementImpl.ALL_KINDS, true);
    }

    public Collection getDependent(ModelElement provider) {
        Set result = new HashSet();
        findDependentElements(provider, result);
        return result;
    }
    
    private void findDependentElements(ModelElement provider, Set result) {
        Set temp = new HashSet();
        ModelPackage pkg = (ModelPackage) refImmediatePackage();

        if (provider instanceof Constraint) {
            temp.addAll(((Constraint) provider).getConstrainedElements());
        } else if (provider instanceof Namespace) {
            temp.addAll(((Namespace) provider).getContents());
            temp.addAll(pkg.getAliases().getImporter((Namespace) provider));
            if (provider instanceof GeneralizableElement) {
                temp.addAll(pkg.getGeneralizes().getSubtype((GeneralizableElement) provider));
                if (provider instanceof Classifier) {
                    temp.addAll(pkg.getIsOfType().getTypedElements((Classifier) provider));
                }
            } else if (provider instanceof MofException) {
                temp.addAll(pkg.getCanRaise().getOperation((MofException) provider));
            }
        } else if (provider instanceof AssociationEnd) {
            temp.addAll(pkg.getRefersTo().getReferent((AssociationEnd) provider));
            temp.addAll(pkg.getExposes().getReferrer((AssociationEnd) provider));
        }

        temp.addAll(provider.getConstraints());
        temp.add(provider.getContainer());
        temp.addAll(pkg.getAttachesTo().getTag(provider));

        for (Iterator it = temp.iterator(); it.hasNext();) {
            ModelElement me = (ModelElement) it.next();
            if (result.add(me)) {
                findDependentElements(me, result);
            }
        }
    }
}
