/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmiimpl.mof.model;

import org.netbeans.mdr.handlers.InstanceHandler;
import org.netbeans.mdr.storagemodel.StorableObject;
import javax.jmi.model.*;
import java.util.*;

/**
 * Implements MOF operations for ModelElement class
 *
 * @author Martin Matula
 */
public abstract class ModelElementImpl extends InstanceHandler implements ModelElement {
    // correct constant names
    public static final java.lang.String CONTAINER_DEP = "container";                       //NOI18N
    public static final java.lang.String CONTENTS_DEP = "contents";                         //NOI18N
    public static final java.lang.String SIGNATURE_DEP = "signature";                       //NOI18N
    public static final java.lang.String CONSTRAINT_DEP = "constraint";                     //NOI18N
    public static final java.lang.String CONSTRAINED_ELEMENTS_DEP = "constrained elements"; //NOI18N
    public static final java.lang.String SPECIALIZATION_DEP = "specialization";             //NOI18N
    public static final java.lang.String IMPORT_DEP = "import";                             //NOI18N
    public static final java.lang.String TYPE_DEFINITION_DEP = "type definition";           //NOI18N
    public static final java.lang.String REFERENCED_ENDS_DEP = "referenced ends";           //NOI18N
    public static final java.lang.String TAGGED_ELEMENTS_DEP = "tagged elements";           //NOI18N
    public static final java.lang.String INDIRECT_DEP = "indirect";                         //NOI18N
    public static final java.lang.String ALL_DEP = "all";                                   //NOI18N
    
    static final HashSet ALL_KINDS = new HashSet();
    
    static {
        ALL_KINDS.add(CONTAINER_DEP);
        ALL_KINDS.add(CONTENTS_DEP);
        ALL_KINDS.add(SIGNATURE_DEP);
        ALL_KINDS.add(CONSTRAINT_DEP);
        ALL_KINDS.add(CONSTRAINED_ELEMENTS_DEP);
        ALL_KINDS.add(SPECIALIZATION_DEP);
        ALL_KINDS.add(IMPORT_DEP);
        ALL_KINDS.add(TYPE_DEFINITION_DEP);
        ALL_KINDS.add(REFERENCED_ENDS_DEP);
        ALL_KINDS.add(TAGGED_ELEMENTS_DEP);
    }        
    
    protected ModelElementImpl(StorableObject storable) {
        super(storable);
    }

    private void recursiveFindDeps(Set kinds, Set result) {
        Set temp = new HashSet();
        for (Iterator m = kinds.iterator(); m.hasNext();) {
            findDepsOfKind((String) m.next(), temp);
        }
        for (Iterator it = temp.iterator(); it.hasNext();) {
            ModelElementImpl me = (ModelElementImpl) it.next();
            if (result.add(me)) {
                me.recursiveFindDeps(kinds, result);
            }
        }
    }

    private void findDepsOfKind(String kind, Set result) {
        if (kind.equals(CONSTRAINT_DEP)) { // constraint
            result.addAll(this.getConstraints());
        } else if (kind.equals(CONTAINER_DEP)) { //container
            result.add(this.getContainer());
        } else if (kind.equals(CONSTRAINED_ELEMENTS_DEP) && (this instanceof Constraint)) { //constrained elements
            result.addAll(((Constraint) this).getConstrainedElements());
        } else if (kind.equals(SPECIALIZATION_DEP) && (this instanceof GeneralizableElement)) { //specialization
            result.addAll(((GeneralizableElement) this).getSupertypes());
        } else if (kind.equals(IMPORT_DEP) && (this instanceof Import)) { //import
            result.add(((Import) this).getImportedNamespace());
        } else if (kind.equals(CONTENTS_DEP) && (this instanceof Namespace)) { //contents
            result.addAll(((Namespace) this).getContents());
        } else if (kind.equals(SIGNATURE_DEP) && (this instanceof Operation)) { //signature
            result.addAll(((Operation) this).getExceptions());
        } else if (kind.equals(TAGGED_ELEMENTS_DEP) && (this instanceof Tag)) { //tagged elements
            result.addAll(((Tag) this).getElements());
        } else if (kind.equals(TYPE_DEFINITION_DEP) && (this instanceof TypedElement)) { //type definition
            result.add(((TypedElement) this).getType());
        } else if (kind.equals(REFERENCED_ENDS_DEP) && (this instanceof Reference)) { //referenced ends
            result.add(((Reference) this).getReferencedEnd());
            result.add(((Reference) this).getExposedEnd());
        }

        result.remove(null);
    }

    private boolean isDepOfKind(String kind, ModelElement otherElement) {
        HashSet result = new HashSet();
        findDepsOfKind(kind, result);
        return result.contains(otherElement);
    }

    // --- operations

    public boolean isFrozen() {
        // [PENDING] has to be implemented to return true if there already exists an instance of this element
        return false;
    }

    public Collection findRequiredElements(Collection kinds, boolean recursive) {
        _lock(false);
        try {
            if (kinds.contains(ALL_DEP)) {
                return findRequiredElements(ALL_KINDS, recursive);
            } else {
                Set newKinds = (kinds == ALL_KINDS ? ALL_KINDS : new HashSet(kinds));
                Set result = new HashSet();
                if (recursive) {
                    recursiveFindDeps(newKinds, result);
                } else {
                    String kind;
                    for (Iterator it = kinds.iterator(); it.hasNext();) {
                        kind = (String) it.next();
                        findDepsOfKind(kind, result);
                    }
                }
                return result;
            }
        } finally {
            _unlock();
        }
    }
    
    public boolean isVisible(ModelElement otherElement) {
        return true;
    }

    public boolean isRequiredBecause(ModelElement otherElement, String[] reason) {
        _lock(false);
        try {
            for (Iterator it = ALL_KINDS.iterator(); it.hasNext();) {
                reason[0] = (String) it.next();
                if (isDepOfKind(reason[0], otherElement)) {
                    return true;
                }
            }

            if (findRequiredElements(ALL_KINDS, true).size() > 0) {
                reason[0] = INDIRECT_DEP;
            } else {
                reason[0] = "";
                return false;
            }

            return true;
        } finally {
            _unlock();
        }
    }

    // --- derived attributes

    public List getQualifiedName() {
        List result;
        Namespace container = getContainer();

        if (container == null) {
            result = new ArrayList();
        } else {
            result = new ArrayList(container.getQualifiedName());
        }
        result.add(getName());
        return result;
    }
}
