/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.jmiimpl.mof.model;

import java.util.Collection;
import javax.jmi.model.AssociationEnd;
import javax.jmi.model.Classifier;
import javax.jmi.model.MultiplicityType;
import javax.jmi.model.Reference;
import javax.jmi.model.RefersTo;
import org.netbeans.mdr.handlers.AssociationHandler;
import org.netbeans.mdr.storagemodel.StorableAssociation;
import org.netbeans.mdr.util.Logger;

/**
 *
 * @author  mm109185
 */
public abstract class RefersToImpl extends AssociationHandler implements RefersTo {
    
    /** Creates a new instance of RefersToImpl */
    public RefersToImpl(StorableAssociation s) {
        super(s);
    }
    
    public boolean add(Reference reference, AssociationEnd associationEnd) {
        boolean result = super_add(reference, associationEnd);
        if (result) {
            boolean isChangeable = associationEnd.isChangeable();
            MultiplicityType multiplicity = associationEnd.getMultiplicity();
            
            if (reference.isChangeable() != isChangeable) {
                Logger.getDefault().log(Logger.WARNING, "Reference<->AssociationEnd inconsistency: \n    " +
                    reference.getName() + "[Reference].isChangeable = " + reference.isChangeable() +
                    "\n    " + associationEnd.getName() + "[AssociationEnd].isChangeable = " + isChangeable);
                reference.setChangeable(isChangeable);
                Logger.getDefault().log(Logger.WARNING, "Value of isChangeable attribute of the reference was updated to " + isChangeable);
            } else if (!reference.getMultiplicity().equals(multiplicity)) {
                Logger.getDefault().log(Logger.WARNING, "Reference<->AssociationEnd inconsistency: \n    " +
                    reference.getName() + "[Reference].multiplicity = " + reference.getMultiplicity() +
                    "\n    " + associationEnd.getName() + "[AssociationEnd].multiplicity = " + multiplicity);
                reference.setMultiplicity(multiplicity);
                Logger.getDefault().log(Logger.WARNING, "Value of multiplicity attribute of the reference was updated to " + multiplicity);
            }
        }
        return result;
    }
        
    protected abstract boolean super_add(Reference reference, AssociationEnd associationEnd);
}
