/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr;

import org.netbeans.api.mdr.*;

/**
 * A simple {@link org.netbeans.api.mdr.MDRManager} which manages only one
 * single repository of type {@link NBMDRepositoryImpl}.
 *
 * @author Martin Matula
 * @version 
 */
public class NBMDRManagerImpl extends MDRManager {
    private static final String REPOSITORY_DEFAULT = "Default";
    private final MDRepository rep = new NBMDRepositoryImpl();
    
    /** Creates new manager. */
    public NBMDRManagerImpl() {
    }
    
    /** Returns the default repository. In this implementation the default
     * repository is the only repository managed by this manager. */
    public MDRepository getDefaultRepository() {
        return getRepository(null);
    }
    
    /**
     * Returns the default repository, if <code>name</code> is the name
     * of the default repository. In all other cases <code>null</code> is
     * returned.
     *
     * @return the default repository of <code>null</code>
     */
    public MDRepository getRepository(String name) {
//        if (REPOSITORY_DEFAULT.equals(name)) {
            return rep;
//        } else {
//            return null;
//        }
    }
    
    public String[] getRepositoryNames() {
        return new String[] {REPOSITORY_DEFAULT};
    }
}
