/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.handlers;

import java.util.*;
import javax.jmi.reflect.*;
import org.netbeans.api.mdr.events.AssociationEvent;

import org.netbeans.mdr.util.*;
import org.netbeans.mdr.storagemodel.*;

/**
 *
 * @author Martin Matula
 */
public class AEIndexSetWrapper extends IndexSetWrapper {
    protected final AssociationHandler source;
    protected final EventNotifier.Association notifier;
    protected final TypedCollection innerTC;
    protected final RefObject fixed;
    protected final String endName;
    protected final boolean queryFirstEnd;
    
    /** Creates new CollectionWrapper */
    public AEIndexSetWrapper(AssociationHandler source, RefObject fixed, String endName, AssocEndIndexSet inner, boolean queryFirstEnd) {
        super(source._getMdrStorage(), inner);
        this.source = source;
        this.notifier = storage.getEventNotifier().ASSOCIATION;
        this.innerTC = inner;
        this.fixed = fixed;
        this.endName = endName;
        this.queryFirstEnd = queryFirstEnd;
    }
    
    public void clear() {
        boolean fail = true;
        lock(true);
        try {
            Object elements[] = inner.toArray();
            for (int i = 0; i < elements.length; i++) {
                remove(wrap(elements[i]));
            }
            fail = false;
        } finally {
            unlock(fail);
        }
    }
    
    public boolean addAll(Collection collection) {
        boolean fail = true;
        lock(true);
        try {
            boolean result = false;
            for (Iterator it = collection.iterator(); it.hasNext();) {
                result |= add(it.next());
            }
            fail = false;
            return result;
        } finally {
            unlock(fail);
        }
    }
    
    public boolean retainAll(Collection collection) {
        boolean fail = true;
        lock(true);
        try {
            boolean result = false;
            Object elements[] = inner.toArray();
            for (int i = 0; i < elements.length; i++) {
                Object w = wrap(elements[i]);
                if (!collection.contains(w)) {
                    remove(w);
                    result = true;
                }
            }
            fail = false;
            return result;
        } finally {
            unlock(fail);
        }
    }
    
    public boolean removeAll(Collection collection) {
        boolean fail = true;
        lock(true);
        try {
            boolean result = false;
            for (Iterator it = collection.iterator(); it.hasNext();) {
                result |= remove(it.next());
            }
            fail = false;
            return result;
        } finally {
            unlock(fail);
        }
    }
    
    public boolean remove(Object obj) {
        boolean fail = true;
        innerTC.checkType(obj);
        lock(true);
        try {
            if (storage.eventsEnabled()) {
                AssociationEvent event = new AssociationEvent(
                source,
                AssociationEvent.EVENT_ASSOCIATION_REMOVE,
                fixed,
                endName,
                (RefObject) obj,
                null,
                AssociationEvent.POSITION_NONE);
                notifier.firePlannedChange(source, event);
            }
            boolean result = inner.remove(unwrap(obj));
            if (!this.fixed.refOutermostPackage().equals(((RefObject)obj).refOutermostPackage())) {
                RefObject objectA;
                RefObject objectB;
                if (!this.queryFirstEnd) {
                    objectA = (RefObject) obj;
                    objectB = this.fixed;
                }
                else {
                    objectA = this.fixed;
                    objectB = (RefObject) obj;
                }
                AssociationHandler._removeExternalLink(this.source,objectA,objectB);
            }
            fail = false;
            return result;
        } finally {
            unlock(fail);
        }
    }
    
    public boolean add(Object obj) {
        boolean fail = true;
        innerTC.checkType(obj);
        lock(true);
        try {
            if (storage.eventsEnabled()) {
                AssociationEvent event = new AssociationEvent(
                source,
                AssociationEvent.EVENT_ASSOCIATION_ADD,
                fixed,
                endName,
                null,
                (RefObject) obj,
                AssociationEvent.POSITION_NONE);
                notifier.firePlannedChange(source, event);
            }
            boolean result = inner.add(unwrap(obj));
            if (!this.fixed.refOutermostPackage().equals(((RefObject)obj).refOutermostPackage())) {
                RefObject objectA;
                RefObject objectB;
                if (!this.queryFirstEnd) {
                    objectA = (RefObject) obj;
                    objectB = this.fixed;
                }
                else {
                    objectA = this.fixed;
                    objectB = (RefObject) obj;
                }
                AssociationHandler._addExternalLink(this.source,objectA,objectB);
            }
            fail = false;
            return result;
        } finally {
            unlock(fail);
        }
    }
    
    public Iterator iterator() {
        lock(false);
        try {
            return new AEIndexIteratorWrapper(inner.iterator());
        } finally {
            unlock();
        }
    }
    
    protected class AEIndexIteratorWrapper extends IndexIteratorWrapper {
        protected RefObject lastRead = null;
        
        public AEIndexIteratorWrapper(Iterator innerIterator) {
            super(innerIterator);
        }
        
        public Object next() {
            return (lastRead = (RefObject) super.next());
        }
        
        public void remove() {
            boolean fail = true;
            lock(true);
            try {
                if (storage.eventsEnabled()) {
                    AssociationEvent event = new AssociationEvent(
                    source,
                    AssociationEvent.EVENT_ASSOCIATION_REMOVE,
                    fixed,
                    endName,
                    lastRead,
                    null,
                    AssociationEvent.POSITION_NONE);
                    notifier.firePlannedChange(source, event);
                }
                innerIterator.remove();
                if (!fixed.refOutermostPackage().equals(lastRead.refOutermostPackage())) {
                    RefObject objectA;
                    RefObject objectB;
                    if (!queryFirstEnd) {
                        objectA = lastRead;
                        objectB = fixed;
                    }
                    else {
                        objectA = fixed;
                        objectB = lastRead;
                    }
                    AssociationHandler._removeExternalLink(source,objectA,objectB);
                }
                fail = false;
            } finally {
                unlock(fail);
            }
        }
    }
}
