/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.handlers;

import java.util.*;
import javax.jmi.reflect.*;
import org.netbeans.api.mdr.events.AssociationEvent;

import org.netbeans.mdr.storagemodel.*;

/**
 *
 * @author Martin Matula
 */
public class AEIndexUListWrapper extends AEIndexSetWrapper implements List {
    private final List innerList;
    
    /** Creates new ListWrapper */
    public AEIndexUListWrapper(AssociationHandler source, RefObject fixed, String endName, AssocEndIndexUList inner, boolean queryFirstEnd) {
        super(source, fixed, endName, inner, queryFirstEnd);
        this.innerList = inner;
    }
    
    public Object remove(int param) {
        boolean fail = true;
        lock(true);
        try {
            if (storage.eventsEnabled()) {
                AssociationEvent event = new AssociationEvent(
                source,
                AssociationEvent.EVENT_ASSOCIATION_REMOVE,
                fixed, endName,
                (RefObject) get(param), null,
                param);
                notifier.firePlannedChange(source, event);
            }
            Object result = wrap(innerList.remove(param));
            if (!this.fixed.refOutermostPackage().equals(((RefObject)result).refOutermostPackage())) {
                RefObject objectA;
                RefObject objectB;
                if (!queryFirstEnd) {
                    objectA = (RefObject) result;
                    objectB = this.fixed;
                }
                else {
                    objectA = this.fixed;
                    objectB = (RefObject) result;
                }
                AssociationHandler._removeExternalLink(this.source, objectA, objectB);
            }
            fail = false;
            return result;
        } finally {
            unlock(fail);
        }
    }
    
    public void add(int param, Object obj) {
        boolean fail = true;
        innerTC.checkType(obj);
        lock(true);
        try {
            if (storage.eventsEnabled()) {
                AssociationEvent event = new AssociationEvent(
                source,
                AssociationEvent.EVENT_ASSOCIATION_ADD,
                fixed, endName,
                null, (RefObject) obj,
                param);
                notifier.firePlannedChange(source, event);
            }
            innerList.add(param, unwrap(obj));
            if (!this.fixed.refOutermostPackage().equals(((RefObject)obj).refOutermostPackage())) {
                RefObject objectA;
                RefObject objectB;
                if (!queryFirstEnd) {
                    objectA = (RefObject) obj;
                    objectB = this.fixed;
                }
                else {
                    objectA = this.fixed;
                    objectB = (RefObject) obj;
                }
                AssociationHandler._addExternalLink(this.source, objectA, objectB);
            }
            fail = false;
        } finally {
            unlock(fail);
        }
    }
    
    
    public Object set(int param, Object obj) {
        boolean fail = true;
        innerTC.checkType(obj);
        lock(true);
        try {
            if (storage.eventsEnabled()) {
                AssociationEvent event = new AssociationEvent(
                source,
                AssociationEvent.EVENT_ASSOCIATION_SET,
                fixed, endName,
                (RefObject) get(param), (RefObject) obj,
                param);
                notifier.firePlannedChange(source, event);
            }
            Object result = wrap(innerList.set(param, unwrap(obj)));
            if (!this.fixed.refOutermostPackage().equals(((RefObject)result).refOutermostPackage())) {
                RefObject objectA;
                RefObject objectB;
                if (!this.queryFirstEnd) {
                    objectA = (RefObject) result;
                    objectB = this.fixed;
                }
                else {
                    objectA = this.fixed;
                    objectB = (RefObject) result;
                }
                AssociationHandler._removeExternalLink(this.source, objectA, objectB);
            }
            if (!this.fixed.refOutermostPackage().equals(((RefObject)obj).refOutermostPackage())) {
                RefObject objectA;
                RefObject objectB;
                if (!this.queryFirstEnd) {
                    objectA = (RefObject) obj;
                    objectB = this.fixed;
                }
                else {
                    objectA = this.fixed;
                    objectB = (RefObject) obj;
                }
                AssociationHandler._addExternalLink (this.source, objectA, objectB);
            }
            fail = false;
            return result;
        } finally {
            unlock(fail);
        }
    }
    
    public boolean addAll(Collection collection) {
        boolean fail = true;
        lock(true);
        try {
            ListIterator lit = listIterator(size());
            for (Iterator it = collection.iterator(); it.hasNext();) {
                lit.add(it.next());
            }
            fail = false;
            return true;
        } finally {
            unlock(fail);
        }
    }
    
    public boolean addAll(int param, Collection collection) {
        boolean fail = true;
        lock(true);
        try {
            ListIterator lit = listIterator(param);
            for (Iterator it = collection.iterator(); it.hasNext();) {
                lit.add(it.next());
            }
            fail = false;
            return true;
        } finally {
            unlock(fail);
        }
    }
    
    public int indexOf(Object obj) {
        lock(false);
        try {
            return innerList.indexOf(unwrap(obj));
        } finally {
            unlock();
        }
    }
    
    public int lastIndexOf(Object obj) {
        lock(false);
        try {
            return innerList.lastIndexOf(unwrap(obj));
        } finally {
            unlock();
        }
    }
    
    public Object get(int param) {
        lock(false);
        try {
            return wrap(innerList.get(param));
        } finally {
            unlock();
        }
    }
    
    public ListIterator listIterator() {
        lock(false);
        try {
            return new AEIndexListIteratorWrapper(innerList.listIterator());
        } finally {
            unlock();
        }
    }
    
    public ListIterator listIterator(int param) {
        lock(false);
        try {
            return new AEIndexListIteratorWrapper(innerList.listIterator(param));
        } finally {
            unlock();
        }
    }
    
    public List subList(int param, int param1) {
        throw new UnsupportedOperationException();
        //        return new ListWrapper(((List) innerList).subList(param, param1), source);
    }
    
    public boolean equals(Object object) {
        if (object instanceof List) {
            return super.equals(object);
        } else {
            return false;
        }
    }
    
    protected class AEIndexListIteratorWrapper extends AEIndexIteratorWrapper implements ListIterator {
        private final ListIterator listIterator;
        private int lastReadIndex = 0;
        
        public AEIndexListIteratorWrapper(ListIterator innerIterator) {
            super(innerIterator);
            this.listIterator = innerIterator;
        }
        
        public void set(Object obj) {
            boolean fail = true;
            innerTC.checkType(obj);
            lock(true);
            try {
                if (storage.eventsEnabled()) {
                    AssociationEvent event = new AssociationEvent(
                    source,
                    AssociationEvent.EVENT_ASSOCIATION_SET,
                    fixed, endName,
                    lastRead, (RefObject) obj,
                    lastReadIndex);
                    notifier.firePlannedChange(source, event);
                }
                listIterator.set(unwrap(obj));
                if (!fixed.refOutermostPackage().equals(lastRead.refOutermostPackage())) {
                    RefObject objectA;
                    RefObject objectB;
                    if (!queryFirstEnd) {
                        objectA = lastRead;
                        objectB = fixed;
                    }
                    else {
                        objectA = fixed;
                        objectB = lastRead;
                    }
                    AssociationHandler._removeExternalLink(source, objectA, objectB);
                }
                if (!fixed.refOutermostPackage().equals(((RefObject)obj).refOutermostPackage())) {
                    RefObject objectA;
                    RefObject objectB;
                    if (!queryFirstEnd) {
                        objectA = (RefObject) obj;
                        objectB = fixed;
                    }
                    else {
                        objectA = fixed;
                        objectB = (RefObject) obj;
                    }
                    AssociationHandler._addExternalLink(source, objectA, objectB);
                }
                fail = false;
            } finally {
                unlock(fail);
            }
        }
        
        public void add(Object obj) {
            boolean fail = true;
            innerTC.checkType(obj);
            lock(true);
            try {
                if (storage.eventsEnabled()) {
                    AssociationEvent event = new AssociationEvent(
                    source,
                    AssociationEvent.EVENT_ASSOCIATION_ADD,
                    fixed, endName,
                    null, (RefObject) obj,
                    nextIndex());
                    notifier.firePlannedChange(source, event);
                }
                listIterator.add(unwrap(obj));
                if (!fixed.refOutermostPackage().equals(((RefObject)obj).refOutermostPackage())) {
                    RefObject objectA;
                    RefObject objectB;
                    if (!queryFirstEnd) {
                        objectA = (RefObject) obj;
                        objectB = fixed;
                    }
                    else {
                        objectA = fixed;
                        objectB = (RefObject) obj;
                    }
                    AssociationHandler._addExternalLink(source, objectA, objectB);
                }
                fail = false;
            } finally {
                unlock(fail);
            }
        }
        
        public int previousIndex() {
            lock(false);
            try {
                return listIterator.previousIndex();
            } finally {
                unlock();
            }
        }
        
        public int nextIndex() {
            lock(false);
            try {
                return listIterator.nextIndex();
            } finally {
                unlock();
            }
        }
        
        public boolean hasPrevious() {
            lock(false);
            try {
                return listIterator.hasPrevious();
            } finally {
                unlock();
            }
        }
        
        public Object previous() {
            lock(false);
            try {
                lastReadIndex = previousIndex();
                return (lastRead = (RefObject) wrap(listIterator.previous()));
            } finally {
                unlock();
            }
        }
        
        public Object next() {
            lock(false);
            try {
                lastReadIndex = nextIndex();
                return super.next();
            } finally {
                unlock();
            }
        }
        
        public void remove() {
            boolean fail = true;
            lock(true);
            try {
                if (storage.eventsEnabled()) {
                    AssociationEvent event = new AssociationEvent(
                    source,
                    AssociationEvent.EVENT_ASSOCIATION_REMOVE,
                    fixed,
                    endName,
                    lastRead,
                    null,
                    lastReadIndex);
                    notifier.firePlannedChange(source, event);
                }
                innerIterator.remove();
                if (!fixed.refOutermostPackage().equals(lastRead.refOutermostPackage())) {
                    RefObject objectA;
                    RefObject objectB;
                    if (!queryFirstEnd) {
                        objectA = lastRead;
                        objectB = fixed;
                    }
                    else {
                        objectA = fixed;
                        objectB = lastRead;
                    }
                    AssociationHandler._removeExternalLink(source, objectA, objectB);
                }
                fail = false;
            } finally {
                unlock(fail);
            }
        }
    }
}
