/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.handlers;

import java.util.*;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.mdr.util.EventNotifier;

/**
 *
 * @author Martin Matula
 */
public class AttrCollWrapper extends AttrImmutCollWrapper {
    protected final EventNotifier.Abstract notifier;
    protected String attrName = null;
    protected final boolean isStatic;
    
    public AttrCollWrapper(FeaturedHandler source, int attrIndex, String attrName) {
        super(source._getMdrStorage(), source, attrIndex, attrName);
        EventNotifier en = source._getMdrStorage().getEventNotifier();
        this.isStatic = source instanceof ClassProxyHandler;
        this.notifier = isStatic ? (EventNotifier.Abstract) en.CLASS : (EventNotifier.Abstract) en.INSTANCE;
    }
    
    public AttrCollWrapper(FeaturedHandler source, Collection inner) {
        super(source._getMdrStorage(), inner);
        this.source = source;
        EventNotifier en = source._getMdrStorage().getEventNotifier();
        this.isStatic = source instanceof ClassProxyHandler;
        this.notifier = isStatic ? (EventNotifier.Abstract) en.CLASS : (EventNotifier.Abstract) en.INSTANCE;
    }
    
    public void setAttrName(String name) {
        this.attrName = name;
    }
    
    public final Iterator iterator() {
        lock(false);
        try {
            return new AttrIteratorWrapper(getInnerCollection().iterator());
        } finally {
            unlock();
        }
    }
    
    public final void clear() {
        boolean fail = true;
        lock(true);
        try {
            Object elements[] = getInnerCollection().toArray();
            for (int i = 0; i < elements.length; i++) {
                remove(elements[i]);
            }
            fail = false;
        } finally {
            unlock(fail);
        }
    }
    
    public final boolean addAll(Collection collection) {
        boolean fail = true;
        lock(true);
        try {
            boolean result = false;
            for (Iterator it = collection.iterator(); it.hasNext();) {
                result |= add(it.next());
            }
            fail = false;
            return result;
        } finally {
            unlock(fail);
        }
    }
    
    public final boolean remove(Object obj) {
        boolean fail = true;
        lock(true);
        try {
            if (storage.eventsEnabled()) {
                AttributeEvent event = new AttributeEvent(
                    source, 
                    isStatic ? AttributeEvent.EVENT_CLASSATTR_REMOVE : AttributeEvent.EVENT_ATTRIBUTE_REMOVE,
                    attrName,
                    obj, null,
                    AttributeEvent.POSITION_NONE);
                notifier.firePlannedChange(source, event);
            }
            boolean result = getInnerCollection().remove(obj);
            fail = false;
            return result;
        } finally {
            unlock(fail);
        }
    }
    
    public final boolean add(Object obj) {
        boolean fail = true;
        lock(true);
        try {
            if (storage.eventsEnabled()) {
                AttributeEvent event = new AttributeEvent(
                    source, 
                    isStatic ? AttributeEvent.EVENT_CLASSATTR_ADD : AttributeEvent.EVENT_ATTRIBUTE_ADD,
                    attrName,
                    null, obj,
                    AttributeEvent.POSITION_NONE);
                notifier.firePlannedChange(source, event);
            }
            boolean result = getInnerCollection().add(obj);
            fail = false;
            return result;
        } finally {
            unlock(fail);
        }
    }
    
    public boolean retainAll(Collection collection) {
        boolean fail = true;
        lock(true);
        try {
            boolean result = false;
            Object elements[] = getInnerCollection().toArray();
            for (int i = 0; i < elements.length; i++) {
                if (!collection.contains(elements[i])) {
                    remove(elements[i]);
                    result = true;
                }
            }
            fail = false;
            return result;
        } finally {
            unlock(fail);
        }
    }
    
    public boolean removeAll(Collection collection) {
        boolean fail = true;
        lock(true);
        try {
            boolean result = false;
            for (Iterator it = collection.iterator(); it.hasNext();) {
                result |= remove(it.next());
            }
            fail = false;
            return result;
        } finally {
            unlock(fail);
        }
    }
    
    protected class AttrIteratorWrapper extends AttrImmutIteratorWrapper {
        protected Object lastRead = null;
        
        protected AttrIteratorWrapper(Iterator innerIterator) {
            super(innerIterator);
        }
        
        public Object next() {
            return (lastRead = super.next());
        }
        
        public void remove() {
            boolean fail = true;
            lock(true);
            try {
                if (storage.eventsEnabled()) {
                    AttributeEvent event = new AttributeEvent(
                        source, 
                        isStatic ? AttributeEvent.EVENT_CLASSATTR_REMOVE : AttributeEvent.EVENT_ATTRIBUTE_REMOVE,
                        attrName,
                        lastRead, null,
                        AttributeEvent.POSITION_NONE);
                    notifier.firePlannedChange(source, event);
                }
                innerIterator.remove();
                fail = false;
            } finally {
                unlock(fail);
            }
        }
    }
}
