/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.handlers;

import java.util.Collection;
import java.util.Iterator;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.storagemodel.StorableFeatured;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.Logger;
import org.netbeans.mdr.util.TransactionMutex;

/**
 *
 * @author Martin Matula
 */
public class AttrImmutCollWrapper implements Collection {
    protected final MdrStorage storage;
    protected FeaturedHandler source;
    protected final String attrName;
    protected final int attrIndex;
    protected final Collection inner;
    
    /** Creates new CollectionWrapper */
    public AttrImmutCollWrapper(MdrStorage storage, FeaturedHandler source, int attrIndex, String attrName) {
        this.storage = storage;
        this.source = source;
        this.attrName = attrName;
        this.attrIndex = attrIndex;
        this.inner = null;
    }
    
    public AttrImmutCollWrapper(MdrStorage storage, Collection inner) {
        this.storage = storage;
        this.inner = inner;
        this.source = null;
        this.attrName = null;
        this.attrIndex = 0;
    }
    
    public Collection getInnerCollection() {
        if (inner != null) {
            return inner;
        } else {
            try {
                if (attrName != null)
                    return (Collection) ((StorableFeatured) source._getDelegate()).getAttribute(attrName);
                else
                    return (Collection) ((StorableObject) source._getDelegate()).getAttribute(attrIndex);
            } catch (StorageException e) {
                throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
            }
        }
    }
    
    protected final void lock(boolean write) {
        storage.getRepository().beginTrans(write);
    }
    
    protected final void unlock() {
        storage.getRepository().endTrans();
    }
    
    protected final void unlock(boolean fail) {
        storage.getRepository().endTrans(fail);
    }

    public final boolean contains(Object obj) {
        lock(false);
        try {
            return getInnerCollection().contains(obj);
        } finally {
            unlock();
        }
    }
    
    public Iterator iterator() {
        lock(false);
        try {
            return new AttrImmutIteratorWrapper(getInnerCollection().iterator());
        } finally {
            unlock();
        }
    }
    
    public final int size() {
        lock(false);
        try {
            return getInnerCollection().size();
        } finally {
            unlock();
        }
    }
    
    public final boolean isEmpty() {
        lock(false);
        try {
            return getInnerCollection().isEmpty();
        } finally {
            unlock();
        }
    }
    
    public final boolean containsAll(Collection collection) {
        lock(false);
        try {
            return getInnerCollection().containsAll(collection);
        } finally {
            unlock();
        }
    }
    
    public final Object[] toArray(Object[] obj) {
        lock(false);
        try {
            return getInnerCollection().toArray(obj);
        } finally {
            unlock();
        }
    }
    
    public final Object[] toArray() {
        lock(false);
        try {
            return getInnerCollection().toArray();
        } finally {
            unlock();
        }
    }
    
    public boolean equals(Object object) {
        if (object == this) return true;
        if (!(object instanceof Collection)) return false;
        lock(false);
        try {
            Iterator it1 = iterator();
            Iterator it2 = ((Collection) object).iterator();
            while(it1.hasNext() && it2.hasNext()) {
                Object o1 = it1.next();
                Object o2 = it2.next();
                if (!(o1==null ? o2==null : o1.equals(o2)))
                    return false;
            }
            return !(it1.hasNext() || it2.hasNext());
        } finally {
            unlock();
        }
    }
    
    public int hashCode() {
        lock(false);
        try {
            int hashCode = 1;
            for (Iterator it = iterator(); it.hasNext();) {
                Object obj = it.next();
                hashCode = 31*hashCode + (obj==null ? 0 : obj.hashCode());
            }
            return hashCode;
        } finally {
            unlock();
        }
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }
    
    public boolean remove(Object obj) {
        throw new UnsupportedOperationException();
    }
    
    public boolean add(Object obj) {
        throw new UnsupportedOperationException();
    }
    
    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }
    
    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }
    
    public void clear() {
        throw new UnsupportedOperationException();
    }
    
    protected class AttrImmutIteratorWrapper implements Iterator {
        protected final Iterator innerIterator;
        
        protected AttrImmutIteratorWrapper(Iterator innerIterator) {
            this.innerIterator = innerIterator;
        }
        
        public final boolean hasNext() {
            lock(false);
            try {
                return innerIterator.hasNext();
            } finally {
                unlock();
            }
        }
        
        public Object next() {
            lock(false);
            try {
                return innerIterator.next();
            } finally {
                unlock();
            }
        }
        
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}
