/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.handlers;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.mdr.storagemodel.MdrStorage;

import org.netbeans.mdr.util.TransactionMutex;

/**
 *
 * @author Martin Matula
 */
public final class AttrImmutListWrapper extends AttrImmutCollWrapper implements List {
    
    /** Creates new ListWrapper */
    public AttrImmutListWrapper(MdrStorage mdrStorage, FeaturedHandler source, int attrIndex, String attrName) {
        super(mdrStorage, source, attrIndex, attrName);
    }
    
    public AttrImmutListWrapper(MdrStorage mdrStorage, Collection inner) {
        super(mdrStorage, inner);
    }
    
    public List getInnerList() {
        return (List) getInnerCollection();
    }
    
    public Object remove(int param) {
        throw new UnsupportedOperationException();
    }
    
    public ListIterator listIterator(int param) {
        lock(false);
        try {
            return new AttrImmutListIteratorWrapper(getInnerList().listIterator(param));
        } finally {
            unlock();
        }
    }
    
    public void add(int param, Object obj) {
        throw new UnsupportedOperationException();
    }
    
    public int indexOf(Object obj) {
        lock(false);
        try {
            return getInnerList().indexOf(obj);
        } finally {
            unlock();
        }
    }
    
    public int lastIndexOf(Object obj) {
        lock(false);
        try {
            return getInnerList().lastIndexOf(obj);
        } finally {
            unlock();
        }
    }
    
    public Object get(int param) {
        lock(false);
        try {
            return getInnerList().get(param);
        } finally {
            unlock();
        }
    }
    
    public Object set(int param, Object obj) {
        throw new UnsupportedOperationException();
    }
    
    public boolean addAll(int param, Collection collection) {
        throw new UnsupportedOperationException();
    }
    
    public ListIterator listIterator() {
        lock(false);
        try {
            return new AttrImmutListIteratorWrapper(getInnerList().listIterator());
        } finally {
            unlock();
        }
    }
    
    public List subList(int param, int param1) {
        lock(false);
        try {
            return new AttrImmutListWrapper(storage, getInnerList().subList(param, param1));
        } finally {
            unlock();
        }
    }
    
    public boolean equals(Object object) {
        if (object instanceof List) {
            return super.equals(object);
        } else {
            return false;
        }
    }
    
    private final class AttrImmutListIteratorWrapper extends AttrImmutIteratorWrapper implements ListIterator {
        private final ListIterator innerListIterator;
        
        AttrImmutListIteratorWrapper(ListIterator innerIterator) {
            super(innerIterator);
            this.innerListIterator = innerIterator;
        }
        
        public int previousIndex() {
            lock(false);
            try {
                return innerListIterator.previousIndex();
            } finally {
                unlock();
            }
        }
        
        public void set(Object obj) {
            throw new UnsupportedOperationException();
        }
        
        public int nextIndex() {
            lock(false);
            try {
                return innerListIterator.nextIndex();
            } finally {
                unlock();
            }
        }
        
        public boolean hasPrevious() {
            lock(false);
            try {
                return innerListIterator.hasPrevious();
            } finally {
                unlock();
            }
        }
        
        public void add(Object obj) {
            throw new UnsupportedOperationException();
        }
        
        public Object previous() {
            lock(false);
            try {
                return innerListIterator.previous();
            } finally {
                unlock();
            }
        }
    }
}
