/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.handlers;

import java.util.*;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.mdr.util.EventNotifier;

/**
 *
 * @author Martin Matula
 */
public final class AttrListWrapper extends AttrCollWrapper implements List {
    
    /** Creates new ListWrapper */
    public AttrListWrapper(FeaturedHandler source, int attrIndex, String attrName) {
        super(source, attrIndex, attrName);
    }
    
    public AttrListWrapper(FeaturedHandler source, Collection inner) {
        super(source, inner);
    }
    
    public List getInnerList() {
        return (List) getInnerCollection();
    }
    
    public Object remove(int param) {
        boolean fail = true;
        lock(true);
        try {
            if (storage.eventsEnabled()) {
                AttributeEvent event = new AttributeEvent(
                    source, 
                    isStatic ? AttributeEvent.EVENT_CLASSATTR_REMOVE : AttributeEvent.EVENT_ATTRIBUTE_REMOVE,
                    attrName,
                    get(param), null,
                    param);
                notifier.firePlannedChange(source, event);
            }
            Object result = getInnerList().remove(param);
            fail = false;
            return result;
        } finally {
            unlock(fail);
        }
    }
    
    public ListIterator listIterator(int param) {
        lock(false);
        try {
            return new AttrListIteratorWrapper(getInnerList().listIterator(param));
        } finally {
            unlock();
        }
    }
    
    public void add(int param, Object obj) {
        boolean fail = true;
        lock(true);
        try {
            if (storage.eventsEnabled()) {
                AttributeEvent event = new AttributeEvent(
                    source, 
                    isStatic ? AttributeEvent.EVENT_CLASSATTR_ADD : AttributeEvent.EVENT_ATTRIBUTE_ADD,
                    attrName,
                    null, obj,
                    param);
                notifier.firePlannedChange(source, event);
            }
            getInnerList().add(param, obj);
            fail = false;
        } finally {
            unlock(fail);
        }
    }
    
    public int indexOf(Object obj) {
        lock(false);
        try {
            return getInnerList().indexOf(obj);
        } finally {
            unlock();
        }
    }
    
    public int lastIndexOf(Object obj) {
        lock(false);
        try {
            return getInnerList().lastIndexOf(obj);
        } finally {
            unlock();
        }
    }
    
    public Object get(int param) {
        lock(false);
        try {
            return getInnerList().get(param);
        } finally {
            unlock();
        }
    }
    
    public Object set(int param, Object obj) {
        boolean fail = true;
        lock(true);
        try {
            if (storage.eventsEnabled()) {
                AttributeEvent event = new AttributeEvent(
                    source, 
                    isStatic ? AttributeEvent.EVENT_CLASSATTR_SET : AttributeEvent.EVENT_ATTRIBUTE_SET,
                    attrName,
                    get(param), obj,
                    param);
                notifier.firePlannedChange(source, event);
            }
            Object result = getInnerList().set(param, obj);
            fail = false;
            return result;
        } finally {
            unlock(fail);
        }
    }
    
    public boolean addAll(int param, Collection collection) {
        boolean fail = true;
        lock(true);
        try {
            for (Iterator it = collection.iterator(); it.hasNext();) {
                add(param++, it.next());
            }
            fail = false;
            return true;
        } finally {
            unlock(fail);
        }
    }
    
    public ListIterator listIterator() {
        lock(false);
        try {
            return new AttrListIteratorWrapper(getInnerList().listIterator());
        } finally {
            unlock();
        }
    }
    
    public List subList(int param, int param1) {
        lock(false);
        try {
            AttrListWrapper result = new AttrListWrapper(source, getInnerList().subList(param, param1));
            result.setAttrName(attrName);
            return result;
        } finally {
            unlock();
        }
    }
    
    public boolean equals(Object object) {
        if (object instanceof List) {
            return super.equals(object);
        } else {
            return false;
        }
    }
    
    private final class AttrListIteratorWrapper extends AttrIteratorWrapper implements ListIterator {
        private final ListIterator innerListIterator;
        protected int lastReadIndex = 0;
        
        AttrListIteratorWrapper(ListIterator innerIterator) {
            super(innerIterator);
            this.innerListIterator = innerIterator;
        }
        
        public int previousIndex() {
            lock(false);
            try {
                return innerListIterator.previousIndex();
            } finally {
                unlock();
            }
        }
        
        public void set(Object obj) {
            boolean fail = true;
            lock(true);
            try {
                if (storage.eventsEnabled()) {
                    AttributeEvent event = new AttributeEvent(
                        source, 
                        isStatic ? AttributeEvent.EVENT_CLASSATTR_SET : AttributeEvent.EVENT_ATTRIBUTE_SET,
                        attrName,
                        lastRead, obj,
                        lastReadIndex);
                    notifier.firePlannedChange(source, event);
                }
                innerListIterator.set(obj);
                fail = false;
            } finally {
                unlock(fail);
            }
        }
        
        public int nextIndex() {
            lock(false);
            try {
                return innerListIterator.nextIndex();
            } finally {
                unlock();
            }
        }
        
        public boolean hasPrevious() {
            lock(false);
            try {
                return innerListIterator.hasPrevious();
            } finally {
                unlock();
            }
        }
        
        public void add(Object obj) {
            boolean fail = true;
            lock(true);
            try {
                if (storage.eventsEnabled()) {
                    AttributeEvent event = new AttributeEvent(
                        source, 
                        isStatic ? AttributeEvent.EVENT_CLASSATTR_ADD : AttributeEvent.EVENT_ATTRIBUTE_ADD,
                        attrName,
                        null, obj,
                        nextIndex());
                    notifier.firePlannedChange(source, event);
                }
                innerListIterator.add(obj);
                fail = false;
            } finally {
                unlock(fail);
            }
        }
        
        public final void remove() {
            boolean fail = true;
            lock(true);
            try {
                if (storage.eventsEnabled()) {
                    AttributeEvent event = new AttributeEvent(
                        source, 
                        isStatic ? AttributeEvent.EVENT_CLASSATTR_REMOVE : AttributeEvent.EVENT_ATTRIBUTE_REMOVE,
                        attrName,
                        lastRead, null,
                        lastReadIndex);
                    notifier.firePlannedChange(source, event);
                }
                innerIterator.remove();
                fail = false;
            } finally {
                unlock(fail);
            }
        }

        public Object previous() {
            lock(false);
            try {
                lastReadIndex = previousIndex();
                return (lastRead = innerListIterator.previous());
            } finally {
                unlock();
            }
        }
        
        public Object next() {
            lock(false);
            try {
                lastReadIndex = nextIndex();
                return super.next();
            } finally {
                unlock();
            }
        }
    }
}
