/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.handlers;

import java.util.*;

import org.netbeans.mdr.storagemodel.TypedCollection;

/**
 *
 * @author Martin Matula
 * @version 
 */
public class CollectionUnwrapper extends AbstractList {
    private final Object[] innerList;
    
    public CollectionUnwrapper(Collection elements, Collection typedList) {
        super();
        
        int i = 0;
        TypedCollection list;
        if (typedList instanceof TypedCollection) {
            list = (TypedCollection) typedList;
        } else {
            list = null;
        }
        innerList = new Object[elements.size()];
        for (Iterator it = elements.iterator(); it.hasNext();) {
            Object element = it.next();
            if (list != null) {
                list.checkType(element);
            }
            innerList[i++] = IndexSetWrapper.unwrap(element);
        }
    }
    
    public CollectionUnwrapper(Collection elements) {
        this(elements, null);
    }
    
    public int size() {
        return innerList.length;
    }
    
    public Object get(int param) {
        return innerList[param];
    }
}
