/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.handlers;

import javax.jmi.model.*;
import javax.jmi.reflect.*;

import java.util.*;

import org.netbeans.api.mdr.events.*;

import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.storagemodel.*;
import org.netbeans.mdr.persistence.StorageException;

/** Invocation handler for featured objects (instances and class proxies)
 *
 * @author Petr Hrebejk, Martin Matula
 * @version 
 */
public abstract class FeaturedHandler extends BaseObjectHandler implements RefFeatured {

    /* -------------------------------------------------------------------- */
    /* -- Constructor ----------------------------------------------------- */
    /* -------------------------------------------------------------------- */

    /** Creates new FeaturedHandler */
    protected FeaturedHandler(StorableFeatured storable) {
        super(storable);
    }

    /* -------------------------------------------------------------------- */
    /* -- Helper methods -------------------------------------------------- */
    /* -------------------------------------------------------------------- */
    
    private StorableFeatured getFeaturedDelegate() {
        return (StorableFeatured) _getDelegate();
    }

    /* -------------------------------------------------------------------- */
    /* -- Methods to be called by generated handlers (_pre, _handle, _post) */
    /* -------------------------------------------------------------------- */
    
    protected final Object _preGet(String featureName) {
        _lock(false);
        return featureName;
    }
    
    protected final void _postGet(Object result, Object extraInfo, boolean fail) {
        try {
            if (result instanceof AttrCollWrapper) {
                ((AttrCollWrapper) result).setAttrName((String) extraInfo);
            }
        } finally {
            _unlock();
        }
    }
    
    protected final Object _preSet(String featureName, Object newValue) {
        boolean fail = true;
        _lock(true);
        try {
            if (_getMdrStorage().eventsEnabled()) {
                Object oldValue = _getAttribute(featureName);
        //        if (newValue == oldValue || (newValue != null && newValue.equals(oldValue))) {
        //            return null;
        //        } else {
                    AttributeEvent event = new AttributeEvent(
                        this, 
                        AttributeEvent.EVENT_ATTRIBUTE_SET, 
                        featureName, 
                        oldValue, 
                        newValue, 
                        AttributeEvent.POSITION_NONE
                    );
                    if (this instanceof RefObject) {
                        _getMdrStorage().getEventNotifier().INSTANCE.firePlannedChange(this, event);
                    } else {
                        _getMdrStorage().getEventNotifier().CLASS.firePlannedChange(this, event);
                    }
                    fail = false;
                    return event;
            }
            fail = false;
            return null;
        } finally {
            if (fail) _unlock(true);
        }
//        }
    }
    
    protected final void _postSet(Object extraInfo, boolean fail) {
        _unlock(fail);
    }
    

    // RefFeatured implementation ------------------------------------------------

    public final Object refInvokeOperation(String operationName, List args) throws RefException {
        return _invokeOperation(operationName, args.toArray());
    }

    public final Object refInvokeOperation(RefObject requestedOperation, List args) throws RefException {
        return _invokeOperation(((Operation) requestedOperation).getName(), args.toArray());
    }

    public void refSetValue(String featureName, java.lang.Object value) {
        _lock(true);
        try {
            _setAttribute(featureName, value); 
        } finally {
            _unlock();
        }
    }
    
    public void refSetValue(RefObject feature, Object value) {
        _lock(true);
        try {
/*            StorableClass cls = getFeaturedDelegate().getClassProxy();
            try {
                StorableClass.AttributeDescriptor desc = cls.getAttrDesc(((Attribute) feature).getName());
                if (!desc.getMofId().equals(feature.refMofId())) throw new InvalidCallException(null, feature);
            } catch (DebugException e) {
                throw new InvalidCallException(null, feature);
            }
*/
            _setAttribute(((Attribute) feature).getName(), value);
        } catch (InvalidNameException e) {
            throw new InvalidCallException(null, feature);
        } catch (ClassCastException e) {
            throw new InvalidCallException(null, feature);
/*        } catch (StorageException e) {
            throw Logger.getDefault().annotate(new DebugException(), e);
*/        } finally {
            _unlock();
        }
    }

    public Object refGetValue(String featureName) {
        _lock(false);
        try {
            return _getAttribute(featureName);
        } finally {
            _unlock();
        }
    }
    
    public Object refGetValue(RefObject feature) {
        _lock(false);
        try {
            /*
            StorableClass cls = getFeaturedDelegate().getClassProxy();
            try {
                StorableClass.AttributeDescriptor desc = cls.getAttrDesc(((Attribute) feature).getName());
                if (!desc.getMofId().equals(feature.refMofId())) throw new InvalidCallException(null, feature);
            } catch (DebugException e) {
                throw new InvalidCallException(null, feature);
            }
            */
            return _getAttribute(((Attribute) feature).getName());
        } catch (InvalidNameException e) {
            throw new InvalidCallException(null, feature);
        } catch (ClassCastException e) {
            throw new InvalidCallException(null, feature);
        /*
        } catch (StorageException e) {
            throw Logger.getDefault().annotate(new DebugException(), e);
         */
        } finally {
            _unlock();
        }
    }

    /* -------------------------------------------------------------------- */
    /* -- abstract methods to be implemented by generated handlers -------- */
    /* -------------------------------------------------------------------- */

    public abstract void _setAttribute(String attrName, Object newValue);
    public abstract Object _getAttribute(String attrName);
    
    public abstract Object _invokeOperation(String operName, Object[] params);
}
