/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mdr.handlers;

import java.util.*;

import org.netbeans.api.mdr.events.*;

import javax.jmi.model.*;
import javax.jmi.reflect.*;

import org.netbeans.mdr.util.*;
import org.netbeans.mdr.storagemodel.*;
import org.netbeans.mdr.persistence.StorageException;

/** Invocation handler for PackageProxies
 *
 * @author Petr Hrebejk, Martin Matula
 */
public abstract class PackageProxyHandler extends BaseObjectHandler implements RefPackage {

    /* -------------------------------------------------------------------- */
    /* -- Private attributes ---------------------------------------------- */
    /* -------------------------------------------------------------------- */

    private HashMap clusteredPackages = null;

    /* -------------------------------------------------------------------- */
    /* -- Constructor ----------------------------------------------------- */
    /* -------------------------------------------------------------------- */
    
    /** Creates new PackageProxy
    */
    protected PackageProxyHandler(StorablePackage storable) {
        super(storable);
    }

    /* -------------------------------------------------------------------- */
    /* -- Helper methods -------------------------------------------------- */
    /* -------------------------------------------------------------------- */

    // Handler specific methods --------------------------------------------------
    private void checkClustered() {
        if (clusteredPackages == null) {
            MofPackage metaPkg = (MofPackage) refMetaObject();
            clusteredPackages = new HashMap();
            ModelElement element;
            for (Iterator it = metaPkg.allSupertypes().iterator(); it.hasNext();) {
                for (Iterator it2 = ((GeneralizableElement) it.next()).getContents().iterator(); it2.hasNext();) {
                    element = (ModelElement) it2.next();
                    if ((element instanceof Import) && ((Import) element).isClustered()) {
                        clusteredPackages.put(((Import) element).getImportedNamespace().refMofId(), element.getName());
                    }
                }
            }
        }
    }

    private StorablePackage getPackageDelegate() {
        return (StorablePackage) _getDelegate();
    }

    /* -------------------------------------------------------------------- */
    /* -- Methods to be called by generated handlers (_pre, _handle, _post) */
    /* -------------------------------------------------------------------- */

    protected final Object _preGetPackageProxy(String proxyName) {
        _lock(false);
        return null;
    }

    protected final RefPackage _handleGetPackageProxy(String proxyName) {
        try {
            return (RefPackage) _getRepository().getHandler(getPackageDelegate().getPackage(proxyName));
        } catch (StorageException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        }
    }
    
    protected final void _postGetPackageProxy(RefPackage result, Object extraInfo, boolean fail) {
        _unlock();
    }

    protected final Object _preGetClassProxy(String proxyName) {
        _lock(false);
        return null;
    }

    protected final RefClass _handleGetClassProxy(String proxyName) {
        try {
            return (RefClass) _getRepository().getHandler(getPackageDelegate().getClassProxy(proxyName));
        } catch (StorageException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        }
    }

    protected final void _postGetClassProxy(RefClass result, Object extraInfo, boolean fail) {
        _unlock();
    }

    protected final Object _preGetAssociationProxy(String proxyName) {
        _lock(false);
        return null;
    }

    protected final RefAssociation _handleGetAssociationProxy(String proxyName) {
        try {
            return (RefAssociation) _getRepository().getHandler(getPackageDelegate().getAssociation(proxyName));
        } catch (StorageException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        }
    }

    protected final void _postGetAssociationProxy(RefAssociation result, Object extraInfo, boolean fail) {
        _unlock();
    }

    protected final Object _preEnum(String enumName, String literal) {
        _lock(false);
        return null;
    }
    
    protected final RefEnum _handleEnum(String enumName, String literal) {
        return EnumResolver.resolveEnum(getPackageDelegate().getDatatypeDesc(enumName).getIfcName(), literal);
    }
    
    protected final void _postEnum(RefEnum result, Object extraInfo, boolean fail) {
        _unlock();
    }
    
    protected final Object _preStruct(String structName, Object fieldValues[]) {
        _lock(false);
        return null;
    }

    protected final RefStruct _handleStruct(String structName, Object fieldValues[]) {
        return StructImpl.newInstance(getPackageDelegate().getDatatypeDesc(structName), fieldValues);
    }

    protected final void _postStruct(RefStruct result, Object extraInfo, boolean fail) {
        _unlock();
    }

    /* -------------------------------------------------------------------- */
    /* -- Implementation of javax.jmi.reflect.RefPackage ------------------ */
    /* -------------------------------------------------------------------- */

    public final Collection refAllAssociations() {
        _lock(false);
        try {
            return new IndexSetWrapper(_getMdrStorage(), getPackageDelegate().getAllAssociations());
        } catch (StorageException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        } finally {
            _unlock();
        }
    }

    public final Collection refAllClasses() {
        _lock(false);
        try {
            return new IndexSetWrapper(_getMdrStorage(), getPackageDelegate().getAllClasses());
        } catch (StorageException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        } finally {
            _unlock();
        }
    }

    public final Collection refAllPackages() {
        _lock(false);
        try {
            return new IndexSetWrapper(_getMdrStorage(), getPackageDelegate().getAllPackages());
        } catch (StorageException e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        } finally {
            _unlock();
        }
    }

    public final RefAssociation refAssociation(String assocName) {
        return _getAssociation(assocName);
    }
    
    public final RefAssociation refAssociation(RefObject assoc) {
        Association a;
        try {
            a = (Association) assoc;
        } catch (ClassCastException e) {
            throw new InvalidCallException(this, assoc, "Invalid association designator: " + assoc);
        }
        try {
            return refAssociation(a.getName());
        } catch (InvalidNameException e) {
            throw new InvalidCallException(this, assoc);
        }
    }

    public final RefPackage refPackage(String name) {
        return _getPackage(name);
    }

    public final RefPackage refPackage(RefObject nestedPackage) {
        MofPackage pkg;
        try {
            pkg = (MofPackage) nestedPackage;
        } catch (ClassCastException e) {
            throw new InvalidCallException(this, nestedPackage, "Invalid package designator: " + nestedPackage);
        }
        _lock(false);
        try {
            checkClustered();
            String name = (String) clusteredPackages.get(pkg.refMofId());
        
            if (name == null) {
                name = pkg.getName();
            }

            return refPackage(name);
        } catch (InvalidNameException e) {
            throw new InvalidCallException(this, nestedPackage);
        } finally {
            _unlock();
        }
    }

    public final RefClass refClass(String name) {
        return _getClass(name);
    }
    
    public final RefClass refClass(RefObject type) {
        MofClass cls;
        try {
            cls = (MofClass) type;
        } catch (ClassCastException e) {
            throw new InvalidCallException(this, type, "Invalid class designator: " + type);
        }
        try {
            return refClass(cls.getName());
        } catch (InvalidNameException e) {
            throw new InvalidCallException(this, type);
        }
    }

    public final RefEnum refGetEnum(String enumName, java.lang.String name) {
        boolean fail = true;
        Object extraInfo = null;
        RefEnum result = null;
        try {
            extraInfo = _preEnum(enumName, name);
            result = _handleEnum(enumName, name);
            fail = false;
            return result;
        } catch (NullPointerException e) {
            throw new InvalidNameException(enumName);
        } finally {
            _postEnum(result, extraInfo, fail);
        }
    }
    
    public final RefEnum refGetEnum(RefObject en, String name) {
        EnumerationType et;
        try {
            et = (EnumerationType) en;
        } catch (ClassCastException e) {
            throw new InvalidCallException(this, en, "Invalid enumeration designator: " + en);
        }
        try {
            return refGetEnum(et.getName(), name);
        } catch (InvalidNameException e) {
            throw new InvalidCallException(this, en);
        }
    }

    public final RefStruct refCreateStruct(String structName, java.util.List params) {
        Object args[] = params.toArray();
        return _createStruct(structName, args);
    }
    
    public final RefStruct refCreateStruct(RefObject struct, List params) {
        StructureType st;
        try {
            st = (StructureType) struct;
        } catch (ClassCastException e) {
            throw new InvalidCallException(this, struct, "Invalid structure designator: " + struct);
        }
        try {
            return refCreateStruct(st.getName(), params);
        } catch (InvalidNameException e) {
            throw new InvalidCallException(this, struct);
        }
    }
    
    public void refDelete() {
        ExtentEvent event = null;
        boolean fail = true;
        _lock(true);
        try {
            if (_getMdrStorage().eventsEnabled()) {
                event = new ExtentEvent(
                    this, 
                    ExtentEvent.EVENT_EXTENT_DELETE,
                    getPackageDelegate().getContext(),
                    refMetaObject(),
                    null
                );
                _getMdrStorage().getEventNotifier().PACKAGE.firePlannedChange(this, event);
            }
            try {
                getPackageDelegate().delete();
            } catch (StorageException e) {
                throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
            }
            fail = false;
        } finally {
            _unlock(fail);
        }
        _getRepository().removeHandler(_getMofId());
    }

    /* -------------------------------------------------------------------- */
    /* -- abstract methods to be implemented by generated handlers -------- */
    /* -------------------------------------------------------------------- */

    public abstract RefClass _getClass(String className);
    public abstract RefAssociation _getAssociation(String associationName);
    public abstract RefPackage _getPackage(String packageName);
    public abstract RefStruct _createStruct(String structName, Object[] params);

    /* -------------------------------------------------------------------- */
    /* -- Implementation of org.netbeans.api.mdr.events.MDRChangeSource --- */
    /* -------------------------------------------------------------------- */
    
    /** Registers a listener for receiving all event notifications
     *  fired on this object.
     * @param listener Object that implements {@link MDRChangeListener} interface.
     */
    public void addListener(MDRChangeListener listener) {
        addListener(listener, MDRChangeEvent.EVENTMASK_ALL);
    }
    
    /** Registers a listener for receiving event notifications.
     * @param listener Object that implements {@link MDRChangeListener} interface.
     * @param mask bitmask to filter types of events the listener listens on
     */
    public void addListener(MDRChangeListener listener, int mask) {
        _getMdrStorage().getEventNotifier().PACKAGE.addListener(listener, mask, this);
    }
    
    /** Removes listener from the list of objects registered for event notifications.
     * @param listener Object that implements {@link MDRChangeListener} interface.
     */
    public void removeListener(MDRChangeListener listener) {
        _getMdrStorage().getEventNotifier().PACKAGE.removeListener(listener, this);
    }
    
    /** Removes listener from the list of objects registered for event notifications.
     * @param listener Object that implements {@link MDRChangeListener} interface.
     * @param mask determines type of the events the listeners stops to listen on
     */
    public void removeListener(MDRChangeListener listener, int mask) {
        _getMdrStorage().getEventNotifier().PACKAGE.removeListener(listener, mask, this);
    }

    /* ---------------------------------------------------------------- */
    /* -- Implementation of abstract methods from BaseObjectHandler --- */
    /* ---------------------------------------------------------------- */

    protected final Collection _recursiveVerify(Collection violations, Set visited) {
        _lock(false);
        try {
            _verify(violations);
            visited.add(this);
            for (Iterator it = refAllPackages().iterator(); it.hasNext();) {
                PackageProxyHandler pkg = (PackageProxyHandler) it.next();
                if (!visited.contains(pkg)) pkg._recursiveVerify(violations, visited);
            }
            for (Iterator it = refAllAssociations().iterator(); it.hasNext();) {
                AssociationHandler assoc = (AssociationHandler) it.next();
                if (!visited.contains(assoc)) assoc._recursiveVerify(violations, visited);
            }
            for (Iterator it = refAllClasses().iterator(); it.hasNext();) {
                ClassProxyHandler cls = (ClassProxyHandler) it.next();
                if (!visited.contains(cls)) cls._recursiveVerify(violations, visited);
            }
            return violations;
        } finally {
            _unlock();
        }
    }
    
    protected Collection _verify(Collection violations) {
        return violations;
    }
}
