/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.handlers.gen;

import java.util.*;
import org.netbeans.mdr.util.*;
import org.netbeans.mdr.storagemodel.*;

/**
 *
 * @author Martin Matula
 * @version 
 */
public class ContainsIterator implements java.util.Iterator {
    
    protected Iterator iterator;
    
    /** Creates new ContainsIterator */
    public ContainsIterator(StorableObject element) {
        ArrayList elements = new ArrayList();
        retrieveContent(element, elements);
        iterator = elements.iterator();
    }
    
    private void retrieveContent(StorableObject element, ArrayList elements) {
        try {
            for (Iterator it = ((List)element.getReference(MOFConstants.SH_MODEL_GENERALIZABLE_ELEMENT_SUPERTYPES)).iterator(); it.hasNext();)
                retrieveContent((StorableObject)it.next(), elements);
            for (Iterator it = ((List)element.getReference(MOFConstants.SH_MODEL_NAMESPACE_CONTENTS)).iterator(); it.hasNext();) {
                StorableObject obj = (StorableObject)it.next();
                if (!elements.contains(obj))
                    elements.add(obj);
            }
        } catch(Exception e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        }
    }
    
    public boolean hasNext() {
        return iterator.hasNext();
    }
    
    public java.lang.Object next() throws NoSuchElementException {
        return iterator.next();
    }
    
    public void remove() throws UnsupportedOperationException, IllegalStateException {
        throw new UnsupportedOperationException();
    }
}
