/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.handlers.gen;

import java.util.*;

import javax.jmi.reflect.*;
import javax.jmi.model.MultiplicityType;

import org.netbeans.mdr.handlers.*;
import org.netbeans.mdr.storagemodel.*;
import org.netbeans.mdr.util.*;

/**
 *
 * @author Martin Matula
 * @version 
 */
public class ContentsFinder extends Object {
    private final HashMap snameToObject = new HashMap();
    private final Class superClass;
    private final String substName;
    private final boolean derived;

    private static String firstUpper(String text) {
        if (text == null) return null;
        if (text.length() < 2) return text.toUpperCase(Locale.US);
        return text.substring(0, 1).toUpperCase(Locale.US) + text.substring(1);
    }

    private void retrieveContents(StorableBaseObject storable, StorableObject meta) throws Exception {
        List contents = (List) meta.getReference(MOFConstants.SH_MODEL_NAMESPACE_CONTENTS);
        StorableObject element;
        String substName;

        for (Iterator it = contents.iterator(); it.hasNext();) {
            element = (StorableObject) it.next();
            substName = TagSupport.getSubstName(element);
            snameToObject.put(firstUpper(substName), new ElementDescriptor(storable, element));
        }

        List supertypes = (List) meta.getReference(MOFConstants.SH_MODEL_GENERALIZABLE_ELEMENT_SUPERTYPES);

        for (Iterator it = supertypes.iterator(); it.hasNext();) {
            element = (StorableObject) it.next();
            retrieveContents(storable, element);
        }
    }
/*    
    public void dump() {
        Logger.getDefault().log("Contents finder dump:");
        for (Iterator it = snameToObject.keySet().iterator(); it.hasNext();) {
            Logger.getDefault().log("    sname: " + it.next());
        }
    }
*/        
    /** Creates new ContentsFinder */
    public ContentsFinder(StorableBaseObject storable) {
        try {
            boolean derived = false;
            StorableObject meta = storable.getMetaObject();
            retrieveContents(storable, meta);
            substName = TagSupport.getSubstName(meta);
            if (storable instanceof StorableAssociation) {
                derived = ((Boolean) meta.getAttribute(MOFConstants.SH_MODEL_ASSOCIATION_IS_DERIVED)).booleanValue();
                Class temp = null;
                if (derived) try {
                    temp = BaseObjectHandler.resolveImplementation(TagSupport.getImplFullName(meta, TagSupport.ASSOCIATION));
                } catch (ClassNotFoundException e) {
                    temp = null;
                }
                if (temp == null) {
                    temp = AssociationHandler.class;
                }
                superClass = temp;
            } else if (storable instanceof StorablePackage) {
                superClass = PackageProxyHandler.class;
            } else if (storable instanceof StorableObject) {
                superClass = ((StorableObject) storable).getClassProxy().getInstanceSuperclass();
            } else if (storable instanceof StorableClass) {
                superClass = ((StorableClass) storable).getClassSuperclass();
            } else {
                superClass = null;
            }
            this.derived = derived;
        } catch (Exception e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        }
    }
    
    public Class getHandlerClass() {
        return superClass;
    }
    
    public String getSubstName() {
        return substName;
    }
    
    public boolean isDerived() {
        return derived;
    }

    public ElementDescriptor lookup(String substName) {
        return (ElementDescriptor) snameToObject.get(firstUpper(substName));
    }
    
    public class ElementDescriptor {
        public static final int ATTRIBUTE = 1;
        public static final int REFERENCE = 2;
        public static final int OPERATION = 4;
        public static final int CLASS = 8;
        public static final int PACKAGE = 16;
        public static final int ASSOCIATION = 32;
        public static final int DATATYPE = 64;
        public static final int ASSOCIATION_END = 128;
        public static final int IMPORT = 256;
        
        private final String name;
        private final int type;
        private final boolean multivalued;
        private final boolean ordered;
        private final boolean writable;
        private final boolean derived;
        private final int index;
        
        private ElementDescriptor(StorableBaseObject parent, StorableObject storable) {
            try {
                name = (String) storable.getAttribute(MOFConstants.SH_MODEL_MODEL_ELEMENT_NAME);
                String typeName = (String) storable.getMetaObject().getAttribute(MOFConstants.SH_MODEL_MODEL_ELEMENT_NAME);

                boolean multivalued = false;
                boolean ordered = false;
                boolean writable = false;
                boolean derived = false;
                int index = 0;

                if (typeName.equals(MOFConstants.SH_MODEL_ATTRIBUTE) || typeName.equals(MOFConstants.SH_MODEL_REFERENCE)) {
                    MultiplicityType multiplicity = (MultiplicityType) storable.getAttribute(MOFConstants.SH_MODEL_STRUCTURAL_FEATURE_MULTIPLICITY);
                    multivalued = !((multiplicity.getUpper() == 1) && (multiplicity.getLower() == 1));
                    ordered = multiplicity.isOrdered() && multivalued;
                    writable = ((Boolean) storable.getAttribute(MOFConstants.SH_MODEL_STRUCTURAL_FEATURE_IS_CHANGEABLE)).booleanValue();
                    if (typeName.equals(MOFConstants.SH_MODEL_REFERENCE)) {
                        type = 2;
                    } else {
                        type = 1;
                        derived = ((Boolean) storable.getAttribute(MOFConstants.SH_MODEL_ASSOCIATION_IS_DERIVED)).booleanValue();
                        if (!derived) {
                            index = ((StorableFeatured) parent).getClassProxy().getAttrIndex(name);
                        }
                    }
                } else if (typeName.equals(MOFConstants.SH_MODEL_OPERATION)) {
                    type = 4;
                    derived = true;
                } else if (typeName.equals(MOFConstants.SH_MODEL_CLASS)) {
                    type = 8;
                } else if (typeName.equals(MOFConstants.SH_MODEL_PACKAGE)) {
                    type = 16;
                } else if (typeName.equals(MOFConstants.SH_MODEL_ASSOCIATION)) {
                    type = 32;
                } else if (typeName.equals(MOFConstants.SH_MODEL_ENUMERATION_TYPE) || typeName.equals(MOFConstants.SH_MODEL_STRUCTURE_TYPE)) {
                    type = 64;
                } else if (typeName.equals(MOFConstants.SH_MODEL_ASSOCIATION_END)) {
                    type = 128;
                } else if (typeName.equals(MOFConstants.SH_MODEL_IMPORT)) {
                    type = 256;
                } else {
                    type = 0;
                }

                this.multivalued = multivalued;
                this.ordered = ordered;
                this.writable = writable;
                this.derived = derived;
                this.index = index;
            } catch (Exception e) {
                throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
            }
        }
        
        public String getName() {
            return name;
        }
        
        public int getIndex() {
            return index;
        }
        
        public boolean isOfType(int type) {
            return (this.type & type) != 0;
        }
        
        public boolean isMultivalued() {
            return multivalued;
        }
        
        public boolean isOrdered() {
            return ordered;
        }
        
        public boolean canModify() {
            return writable;
        }
        
        public boolean isDerived() {
            return derived;
        }
    }
}
