/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.handlers.gen;

import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.mdr.storagemodel.StorablePackage;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.Logger;
import org.netbeans.mdr.util.MOFConstants;
import javax.jmi.model.VisibilityKind;
import javax.jmi.model.VisibilityKindEnum;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.*;

/**
 *
 * @author Martin Matula, Dusan Balek
 * @version 
 */
class PackageGenerator extends HandlerGenerator {
    private static final String CLASS_SUFFIX = "Class"; //NOI18N
    private static final String PACKAGE_SUFFIX = "Package"; //NOI18N

    private static final String M_ASSOC_NAME = "GetAssociationProxy"; //NOI18N
    private static final String M_ASSOC_DESC = "(Ljava/lang/String;)"; //NOI18N
    private static final String M_ASSOC_TYPE = "Ljavax/jmi/reflect/RefAssociation;"; //NOI18N
    private static final String M_CLASS_NAME = "GetClassProxy"; //NOI18N
    private static final String M_CLASS_DESC = "(Ljava/lang/String;)"; //NOI18N
    private static final String M_CLASS_TYPE = "Ljavax/jmi/reflect/RefClass;"; //NOI18N
    private static final String M_PACKAGE_NAME = "GetPackageProxy"; //NOI18N
    private static final String M_PACKAGE_DESC = "(Ljava/lang/String;)"; //NOI18N
    private static final String M_PACKAGE_TYPE = "Ljavax/jmi/reflect/RefPackage;"; //NOI18N
    private static final String M_STRUCT_NAME = "Struct"; //NOI18N
    private static final String M_STRUCT_DESC = "(Ljava/lang/String;[Ljava/lang/Object;)"; //NOI18N
    private static final String M_STRUCT_TYPE = "Ljavax/jmi/reflect/RefStruct;"; //NOI18N
    
    PackageGenerator(String name, Class ifc, Class handler, StorablePackage storable, Class custom) {
        super(name, ifc, handler, storable, custom);
        dispatchMethods.put("_getClass", new HashMap()); //NOI18N
        dispatchMethods.put("_getAssociation", new HashMap()); //NOI18N
        dispatchMethods.put("_getPackage", new HashMap()); //NOI18N
        dispatchMethods.put("_createStruct", new HashMap()); //NOI18N
    }
    
    protected String getConstructorDescriptor() {
        return "(Lorg/netbeans/mdr/storagemodel/StorablePackage;)V"; //NOI18N
    }
    
    protected MethodInfo[] generateMethods() throws IOException {
        try {
            ArrayList methods = new ArrayList();
            HashSet createdMethods = new HashSet();
	    methods.add(generateConstructor());
            for (Iterator it = new ContainsIterator(obj.getMetaObject()); it.hasNext();) {
                StorableObject element = (StorableObject) it.next();
                String elementName = (String) element.getAttribute(MOFConstants.SH_MODEL_MODEL_ELEMENT_NAME);
                String metaTypeName = (String) element.getMetaObject().getAttribute(MOFConstants.SH_MODEL_MODEL_ELEMENT_NAME);
                String substName = TagSupport.getSubstName(element, elementName, metaTypeName);
                String typeName = TagSupport.getTypeFullName(element, substName);
                if (metaTypeName.equals(MOFConstants.SH_MODEL_ASSOCIATION)) {
                    VisibilityKind visibility = (VisibilityKind) element.getAttribute(MOFConstants.SH_MODEL_GENERALIZABLE_ELEMENT_VISIBILITY);
                    if (visibility.equals(VisibilityKindEnum.PUBLIC_VIS)) {
                        String sign = "get" + substName + getMethodDescriptor(new String[0], typeName); //NOI18N
                        if (!createdMethods.contains(sign)) {
                            methods.addAll(getPackageMethod("get" + substName, new String[0], typeName, M_ASSOC_NAME, M_ASSOC_DESC, M_ASSOC_TYPE, elementName, "_getAssociation")); //NOI18N
                            createdMethods.add(sign);
                        }
                    }
                } else if (metaTypeName.equals(MOFConstants.SH_MODEL_CLASS)) {
                    VisibilityKind visibility = (VisibilityKind) element.getAttribute(MOFConstants.SH_MODEL_GENERALIZABLE_ELEMENT_VISIBILITY);
                    if (visibility.equals(VisibilityKindEnum.PUBLIC_VIS)) {
                        String sign = "get" + substName + getMethodDescriptor(new String[0], typeName + CLASS_SUFFIX); //NOI18N
                        if (!createdMethods.contains(sign)) {
                            methods.addAll(getPackageMethod("get" + substName, new String[0], typeName + CLASS_SUFFIX, M_CLASS_NAME, M_CLASS_DESC, M_CLASS_TYPE, elementName, "_getClass")); //NOI18N
                            createdMethods.add(sign);
                        }
                    }
                } else if (metaTypeName.equals(MOFConstants.SH_MODEL_PACKAGE)) {
                    VisibilityKind visibility = (VisibilityKind) element.getAttribute(MOFConstants.SH_MODEL_GENERALIZABLE_ELEMENT_VISIBILITY);
                    if (visibility.equals(VisibilityKindEnum.PUBLIC_VIS)) {
                        String sign = "get" + substName + getMethodDescriptor(new String[0], typeName + PACKAGE_SUFFIX); //NOI18N
                        if (!createdMethods.contains(sign)) {
                            methods.addAll(getPackageMethod("get" + substName, new String[0], typeName + PACKAGE_SUFFIX, M_PACKAGE_NAME, M_PACKAGE_DESC, M_PACKAGE_TYPE, elementName, "_getPackage")); //NOI18N
                            createdMethods.add(sign);
                        }
                    }
                } else if (metaTypeName.equals(MOFConstants.SH_MODEL_STRUCTURE_TYPE)) {
                    ArrayList parameters = new ArrayList();
                    for (Iterator itt = ((List) element.getReference(MOFConstants.SH_MODEL_NAMESPACE_CONTENTS)).iterator(); itt.hasNext();) {
                        StorableObject field = (StorableObject) itt.next();
                        String fieldTypeName = (String) field.getMetaObject().getAttribute(MOFConstants.SH_MODEL_MODEL_ELEMENT_NAME);
                        if (fieldTypeName.equals(MOFConstants.SH_MODEL_STRUCTURE_FIELD))
                            parameters.add(getTypeName2(field));
                    }
                    String[] prms = (String[])parameters.toArray(new String[parameters.size()]);
                    String sign = "create" + firstUpper(substName) + getMethodDescriptor(prms, typeName); //NOI18N
                    if (!createdMethods.contains(sign)) {
                        methods.addAll(getCreateMethod("create" + firstUpper(substName), prms, typeName, M_STRUCT_NAME, M_STRUCT_DESC, M_STRUCT_TYPE, elementName)); //NOI18N
                        createdMethods.add(sign);
                    }
                } else if (metaTypeName.equals(MOFConstants.SH_MODEL_IMPORT)) {
                    VisibilityKind visibility = (VisibilityKind) element.getAttribute(MOFConstants.SH_MODEL_GENERALIZABLE_ELEMENT_VISIBILITY);
                    boolean clustered = ((Boolean) element.getAttribute(MOFConstants.SH_MODEL_IMPORT_IS_CLUSTERED)).booleanValue();
                    StorableObject namespace = (StorableObject) element.getReference(MOFConstants.SH_MODEL_IMPORT_IMPORTED_NAMESPACE);
                    VisibilityKind nsVisibility = (VisibilityKind) namespace.getAttribute(MOFConstants.SH_MODEL_GENERALIZABLE_ELEMENT_VISIBILITY);
                    if (visibility.equals(VisibilityKindEnum.PUBLIC_VIS) && nsVisibility.equals(VisibilityKindEnum.PUBLIC_VIS) && clustered) {
                        String retName = TagSupport.getTypeFullName(namespace) + PACKAGE_SUFFIX;
                        String sign = "get" + substName + getMethodDescriptor(new String[0], retName); //NOI18N
                        if (!createdMethods.contains(sign)) {
                            methods.addAll(getPackageMethod("get" + substName, new String[0], retName, M_PACKAGE_NAME, M_PACKAGE_DESC, M_PACKAGE_TYPE, elementName, "_getPackage")); //NOI18N
                            createdMethods.add(sign);
                        }
                    }
                }
            }
            methods.add(getDispatcherMethod("_getClass", new String[] {"java.lang.String"}, "javax.jmi.reflect.RefClass", (HashMap) dispatchMethods.get("_getClass"))); //NOI18N
            methods.add(getDispatcherMethod("_getAssociation", new String[] {"java.lang.String"}, "javax.jmi.reflect.RefAssociation", (HashMap) dispatchMethods.get("_getAssociation"))); //NOI18N
            methods.add(getDispatcherMethod("_getPackage", new String[] {"java.lang.String"}, "javax.jmi.reflect.RefPackage", (HashMap) dispatchMethods.get("_getPackage"))); //NOI18N
            methods.add(getDispatcherMethod("_createStruct", new String[] {"java.lang.String", "java.lang.Object[]"}, "javax.jmi.reflect.RefStruct", (HashMap) dispatchMethods.get("_createStruct"))); //NOI18N
            return (MethodInfo[]) methods.toArray(new MethodInfo[methods.size()]);
        } catch (Exception e) {
            throw (DebugException) Logger.getDefault().annotate(new DebugException(), e);
        }
    }
    
    protected Collection getPackageMethod(String methodName, String[] parameterTypes, String returnType, String handlerName, String handlerDescriptor, String handlerType, String featureName, String dispatcher) throws IOException, StorageException {
        if (dispatcher != null) {
            HashMap item = (HashMap) dispatchMethods.get(dispatcher);
            item.put(featureName, new MethodDescHolder(methodName, parameterTypes, returnType));
        }
        return getHandlerMethod(methodName, parameterTypes, returnType, handlerName, handlerDescriptor, handlerType, featureName);
    }

    protected Collection getCreateMethod(String methodName, String[] parameterTypes, String returnType, String handlerName, String handlerDescriptor, String handlerType, String featureName) throws IOException {

        if (featureName != null) {
            HashMap item = (HashMap) dispatchMethods.get("_createStruct"); //NOI18N
            item.put(featureName, new MethodDescHolder(methodName, parameterTypes, returnType));
        }

        short delegateMethod = getHandlerIndex(handlerName, handlerDescriptor, handlerType);
        short preMethod = getPreIndex(handlerName, handlerDescriptor);
        short postMethod = getPostIndex(handlerName, handlerType);
        String desc = getMethodDescriptor(parameterTypes, returnType);
        boolean isCustom = customImplContainsMethod(customImpl, methodName, desc);

        int[] parameterSlot = new int[parameterTypes.length];
        int nextSlot = 1;
        for (int i = 0; i < parameterSlot.length; i++) {
            parameterSlot[i] = nextSlot;
            nextSlot += getWordsPerType(parameterTypes[i]);
        }
        int localSlot0 = nextSlot;
        
        short fail = (short) localSlot0;
        short extraInfo = (short) (localSlot0 + 1);
        short result = (short) (localSlot0 + 2);
        short addr = (short) (localSlot0 + 3);
        short exception = (short) (localSlot0 + 4);
        
        MethodInfo minfo = new MethodInfo(methodName, desc, ACC_PUBLIC | ACC_FINAL);
        DataOutputStream out = new DataOutputStream(minfo.getCodeStream());
        MethodInfo cminfo = null;
        DataOutputStream cout = null;
        if (isCustom) {
            cminfo = new MethodInfo(CUSTOM_PREFIX + methodName, desc, ACC_PUBLIC | ACC_FINAL);
            cout = new DataOutputStream(cminfo.getCodeStream());
        }
        
        // store "true" in the fail variable
        out.writeByte(opc_iconst_1);
        code_istore(fail, out);
        // store "null" in the extraInfo variable
        out.writeByte(opc_aconst_null);
        out.writeByte(opc_dup);
        code_astore(extraInfo, out);
        // store "null" in result variable
        code_astore(result, out);
        
        // I'll pass this instance as the first parameter
        code_aload(0, out);
        
        if (featureName != null)
            // feature name stored in the static variable as the second parameter
            code_ldc(cp.getString(featureName), out);
        
        // The rest of parameters we'll put into Object[] array
        code_ipush(parameterTypes.length, out);
        out.writeByte(opc_anewarray);
        out.writeShort(cp.getClass("java/lang/Object")); //NOI18N
        
        for (int i = 0; i < parameterTypes.length; i++) {
            out.writeByte(opc_dup);
            code_ipush(i, out);
            codeWrapArgument(parameterTypes[i], parameterSlot[i], out);
            out.writeByte(opc_aastore);
        }
        
        // call the _pre method
        out.writeByte(opc_invokespecial);
        out.writeShort(preMethod);
        
        // store the returned object in a local variable
        code_astore(extraInfo, out);
        
        // start of the try block
        short tryStart = (short) out.size();

        if (isCustom) {
            // I'll pass this instance as the first parameter
            code_aload(0, out);

            // The rest of parameters follows
            for (int i = 0; i < parameterTypes.length; i++) {
                codeLoad(parameterSlot[i], parameterTypes[i], out);
            }

            // call the custom method
            out.writeByte(opc_invokespecial);
            out.writeShort(cp.getMethodRef(dotToSlash(superclassName), methodName, desc));

            code_astore(result, out);

            // I'll pass this instance as the first parameter
            code_aload(0, cout);

            if (featureName != null)
                // feature name as the second parameter
                code_ldc(cp.getString(featureName), cout);

            // The rest of parameters we'll put into Object[] array
            code_ipush(parameterTypes.length, cout);
            cout.writeByte(opc_anewarray);
            cout.writeShort(cp.getClass("java/lang/Object")); //NOI18N

            for (int i = 0; i < parameterTypes.length; i++) {
                cout.writeByte(opc_dup);
                code_ipush(i, cout);
                codeWrapArgument(parameterTypes[i], parameterSlot[i], cout);
                cout.writeByte(opc_aastore);
            }

            // call the delegate method
            cout.writeByte(opc_invokespecial);
            cout.writeShort(delegateMethod);

            // convert returned object to the result type and return
            cout.writeByte(opc_checkcast);
            cout.writeShort(cp.getClass(dotToSlash(returnType)));
            cout.writeByte(opc_areturn);
        }
        else {
            // I'll pass this instance as the first parameter
            code_aload(0, out);

            if (featureName != null)
                // feature name as the second parameter
                code_ldc(cp.getString(featureName), out);

            // The rest of parameters we'll put into Object[] array
            code_ipush(parameterTypes.length, out);
            out.writeByte(opc_anewarray);
            out.writeShort(cp.getClass("java/lang/Object")); //NOI18N

            for (int i = 0; i < parameterTypes.length; i++) {
                out.writeByte(opc_dup);
                code_ipush(i, out);
                codeWrapArgument(parameterTypes[i], parameterSlot[i], out);
                out.writeByte(opc_aastore);
            }

            // call the delegate method
            out.writeByte(opc_invokespecial);
            out.writeShort(delegateMethod);

            code_astore(result, out);
        }        

        // change value of fail to "false"
        out.writeByte(opc_iconst_0);
        code_istore(fail, out);
        
        // call the finally block and return
        out.writeByte(opc_jsr);
        
        if (isCustom) {
            out.writeShort(3 + getBytesForLoadOrStore(result) + 1 + 2*getBytesForLoadOrStore(exception) + 4);

            // load the returned value
            code_aload(result, out);

            // return
            out.writeByte(opc_areturn);
        }
        else {
            out.writeShort(3 + getBytesForLoadOrStore(result) + 4 + 2*getBytesForLoadOrStore(exception) + 4);

            // load the returned value
            code_aload(result, out);

            // convert it to the result type and return
            out.writeByte(opc_checkcast);
            out.writeShort(cp.getClass(dotToSlash(returnType)));
            out.writeByte(opc_areturn);
        }
        
        // start of catch block
        short catchStart = (short) out.size();
        
        // store exception
        code_astore(exception, out);
        
        // call finally
        out.writeByte(opc_jsr);
        out.writeShort(3 + getBytesForLoadOrStore(exception) + 1);
        
        // load exception
        code_aload(exception, out);
        
        // rethrow exception
        out.writeByte(opc_athrow);
        
        // start of finally block
        // store the return address
        code_astore(addr, out);
        
        // load parameters
        code_aload(0, out);
        code_aload(result, out);
        code_aload(extraInfo, out);
        code_iload(fail, out);
        
        // call the _post method
        out.writeByte(opc_invokespecial);
        out.writeShort(postMethod);
        
        // return from finally
        out.writeByte(opc_ret);
        out.writeByte(addr);
        
        minfo.getExceptionTable().add(new ExceptionTableEntry(tryStart, catchStart, catchStart, (short) 0));
        
        minfo.setMaxStack((short) 15);
        minfo.setMaxLocals((short) (localSlot0 + 5));
        if (isCustom) {
            cminfo.setMaxStack((short)10);
            cminfo.setMaxLocals((short) (localSlot0 + 5));
        }
        
        ArrayList ret = new ArrayList();
        ret.add(minfo);
        if (isCustom)
            ret.add(cminfo);
        return ret;
    }
}
