/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence;

/**
 * Representation of index in the Storage.
 * @author  Pavel Buzek
 * @version 1.0
 */

public interface Index {
    /** Returns the unique name of the index in the Storage.
     * @return
     * @throws StorageException
     */
    public String getName() throws StorageException;

    /** Returns the type of values indexed by this index.
     * @return
     * @throws StorageException
     */
    public Storage.EntryType getValueType() throws StorageException;

    /** Returns the type of keys in index.
     * @return
     * @throws StorageException
     */
    public Storage.EntryType getKeyType() throws StorageException;

    /** Returns a set view of the keys contained in this index.
     * Returned set is read only and may not be modified.
     * @return keys contained in this index
     * @throws StorageException
     */
    public java.util.Set keySet() throws StorageException;

    /** Adds the specified value to values associated in this index with the
     * specified key. If the index puts limit on number of values associated
     * with one key and adding value would break this limit, it throws
     * StorageBadRequestException.
     * @param key
     * @param value
     * @throws StorageException
     */
    public void add(Object key, Object value) throws StorageException;
    
    /** Removes all values assosiated in the index with specified key.
     * @return true if this index changed as a result of this call
     * @param key
     * @throws StorageException
     */
    public boolean remove (Object key) throws StorageException;
}
