/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence;

/**
 *
 * @author  Pavel Buzek
 * @version
 */
public interface MultivaluedIndex extends Index {
    /** Returns a collection view of the values associated in the index with specified key.
     * Returned collection is live and modifiable.
     * If there are no values associated with the key empty collection is returned.
     * @return
     * @param key
     * @throws StorageException
     */
    public java.util.Collection getItems (Object key) throws StorageException;
    /** Like getItems, but if the index contains keys, this returns the objects 
     * corresponding to the key
     * @return
     * @param key
     * @throws StorageException
     */
    public java.util.Collection getObjects (Object key, SinglevaluedIndex repos) throws StorageException;
    /** If true, the collection of values is contrained to hold
     * no more than one of any value.
     * @throws StorageException
     * @param key
     * @param repos where to fetch objects from
     * @return
     */
    public boolean isUnique() throws StorageException;

    /** Removes the first occurrence of the specified element in the list
     * of values associated with the specified key.
     * @return true if this index changed as a result of this call
     * @param key
     * @param value
     */
    public boolean remove (Object key, Object value) throws StorageException;
    
    /** Returns a collection of {@link java.util.Map.Entry} key-value pairs in the index,
     * where key matches the queried prefix.
     * Values are live and modifiable collection, as in case of {@link #getObjects} method.
     * @param prefix queried prefix
     * @param repos primary index
     * @return
     * @throws StorageException
     * @throws UnsupportedOperationException thrown if the index does not support quries on
     * prefixes (due to unsuitable key entry type, etc.)
     */
    public java.util.Collection queryByKeyPrefix (Object prefix, SinglevaluedIndex repos) throws StorageException;
}
