/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence;

import java.util.Map;
/**
 * For any implementation of Storage, the constructor is something like
 * StorageImplementation(name). Different names represent different repositories.
 * The meaning of "name" is implementation-defined.  For btree it will be the
 * base of the file name.
 * This factory is used only to create instances of Storage. Methods to create and
 * delete physical resources for the Storage, open and close the Storage etc. are
 * defined in Storage interface.
 *
 * @author Pavel Buzek
 * @version
 */

public interface StorageFactory {

    /** Creates instance of class that implements Storage interface.
     * throws StorageException if the name is not valid name of a Storage
     */
    public Storage createStorage (Map properties) throws StorageException;

    /** Creates a NULL MOFID in the format used by this Storage 
     *  implementation
     */
    public MOFID createNullMOFID () throws StorageException;
}
