/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence;

import java.io.*;

/**
* This is thrown when an IO error occurs in the storage layer.  The IOException
* is converted to a subclass of Storage Exception to maintain this simple
* rule: only StorageExceptions are thrown from the storage layer. A
* StorageIOException returns the stack trace information of the
* original IOException occurred, since this is far more useful than the stack 
* trace of the point where the exception was converted.
*/

public class StorageIOException extends StorageException {

    /** The original IO Exception that we are converting to a StorageException 
    */
    private IOException ioExcept;

    /** this constructs a StorageIOException from an IOException
    * @param err the IOException
    */
    public StorageIOException(IOException err) {
	super(err.getMessage());
	ioExcept = err;
    }

    /** return the original IOException's message */
    public String getMessage() {
	return ioExcept.getMessage();
    }
	
    /** return the original IOException's localized message */
    public String getLocalizedMessage() {
	return ioExcept.getLocalizedMessage();
    }

    /** print the original IOException's stack trace */
    public void printStackTrace() {
	ioExcept.printStackTrace();
    }

    /** print the original IOException's stack trace */
    public void printStackTrace(PrintStream ps) {
	ioExcept.printStackTrace(ps);
    }

    /** print the original IOException's stack trace */
    public void printStackTrace(PrintWriter pw) {
	ioExcept.printStackTrace(pw);
    }
	
}
