/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence;

/** Every implementation must provide a constructor without parameters.
 * Cache should be able to populate the object using restore method.
 *
 * @author  Pavel Buzek
 * @version 1.0
 */
public interface Streamable {
    /** This method will be used to move changed object from storage cache
     * to the persistent part of storage. It writes the object`s state
     * (set of attributes) in the stream as an array of bytes, for example
     * in textual representation.
     * @param outputStream OutputStream that holds value of a Streamable object
     */
    public void write(java.io.OutputStream outputStream) throws StorageException;
    /** Restore state of the Storable object from the stream.
     * @param inputStream InputStream that represents an internal representation of fields of a Streamable object
     * in which it was written by {@link write } method
     */
    public void read(java.io.InputStream inputStream) throws StorageException;
}
