/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreeindex;
import org.netbeans.mdr.persistence.*;
import java.io.*;
import java.util.*;

/**
 * This is the read-only Collection interface to the set of values contained 
 * in a SinglevaluedBtree.
 *
 * @author	Dana Bergen
 * @version	1.0
 */
public class BtreeCollection extends AbstractCollection {

    protected Btree btree;

    /**
     * Construct a Collection view of a btree.
     *
     * @param	btree	the btree
     */
    public BtreeCollection(Btree btree) {
        this.btree = btree;
    }

    /**
     * Returns the number of items in this btree
     */
    public int size() {
        try {
	    btree.beginRead();
            return btree.countRecords();
	} catch (StorageException e) {
	} finally {
	    btree.endRead();
	}
	return 0;
    }
    
    public boolean isEmpty() {
        return !iterator().hasNext();
    }

    /**
     * Returns an iterator on this BtreeCollection
     */
    public Iterator iterator() {
        return new BtreeIterator(btree);
    }
}
