/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreeindex;

import org.netbeans.mdr.persistence.*;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeStorage;
/**
 * Source of pages for a Btree.
 *
 * @author	Dana Bergen
 * @version	1.0
 */
public interface BtreePageSource extends MofidGenerator {

    /**
     * Get an EntryTypeInfo for the datatype of this BtreePageSource's page IDs.
     */
    public EntryTypeInfo getPageIdInfo();

    /**
     * Retrieve a page.
     *
     * @param	pageId	byte array buffer containing pageId
     * @param	btree	btree to which the page belongs
     *
     * @return	the BtreePage
     * @exception	StorageException
     */
    public BtreePage getPage(byte[] pageId, Btree btree) 
    					throws StorageException;
    /**
     * Creates a new page and returns it.
     *
     * @param	btree	btree to which the page belongs
     *
     * @return	the BtreePage
     * @exception	StorageException
     */
    public BtreePage newPage(Btree btree) throws StorageException;
    /**
     * Creates a new oversize-key page and returns it.
     *
     * @param	btree	btree to which the page belongs
     *
     * @return	the BigKeyPage
     * @exception	StorageException
     */
    public BigKeyPage newBigKeyPage(Btree btree) throws StorageException;
    /**
     * Retrieve the root page for this btree.
     *
     * @param	btree	Btree
     * @return	the root BtreePage
     * @exception	StorageException
     */
    public BtreePage getRootPage(Btree btree) throws StorageException;
    /**
     * Notify the BtreePageSource that the caller is done using this page.
     *
     * @param page	BtreePage
     */
    public void unpinPage(BtreePage page);
    /**
     * Notify the BtreePageSource that the caller is done using this page.
     *
     * @param page	BigKeyPage
     * @exception	StorageException
     */
    public void unpinPage(BigKeyPage page) throws StorageException;
    /**
     * Notify the BtreePageSource that the caller is going to modify this page.
     *
     * @param page	BtreePage
     * @exception	StorageException
     */
    public void dirtyPage(BtreePage page) throws StorageException;
    /**
     * Fills in the provided buffer with a value that represents a null page ID.
     *
     * @param	pageId	byte array to be filled in
     */
    public void setNoPage(byte[] pageId);
    /**
     * Test whether the passed-in pageId is equal to the null page ID.
     *
     * @return	true if the pageId is the null page ID, otherwise false
     */
    public boolean isNoPage(byte[] pageId);
    /**
     * Returns the length of a page ID.
     *
     * @return	length of a page ID from this BtreePageSource
     */
    public int getPageIdLength();
    /**
     * Returns the size of a page.
     *
     * @return	size of a page from this BtreePageSource
     */
    public int getPageSize();
    
    public BtreeStorage getStorage ();
    
}
