/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreeindex;

import org.netbeans.mdr.persistence.btreeimpl.btreestorage.*;	/* for Converter */

/**
 * EntryTypeInfo implementation for integer data.
 */

public class IntInfo extends EntryTypeInfo {

    public String typeName() {
        return "Integer";
    }

    /**
     * Store an integer in a byte array
     *
     * @param i	Integer to be stored
     *
     * @return	byte array containing the integer
     */
    public byte[] toBuffer(Object i) {

	byte[] buffer = new byte[4];

	if (!(i instanceof Integer)) {
	    return null;
	}
	Converter.writeInt(buffer, 0, ((Integer) i).intValue());
	return buffer;
    }

    /**
     * Reads an integer from a byte array
     *
     * @param buffer	byte array containing an integer
     *
     * @return		new Integer containing the value read from the byte array
     */
    public Object fromBuffer(byte[] buffer) {

	return new Integer(Converter.readInt(buffer, 0));
    }

    /**
     * Returns an int read from the 4 bytes starting at the location
     * passed in.
     *
     */
    public int fromBuffer(byte[] buffer, int offset) {

	return Converter.readInt(buffer, offset);
    }

    /**
     * Compares two integers stored in byte arrays
     *
     * @param	key1Buffer	byte array containing integer search key
     * @param	key2Buffer	byte array containing integer target key
     * @param	offset		offset into key2Buffer of target key
     * @param	length		should always be 4
     *
     * @return	Returns one of:
     * <p>EQUAL if the two keys are equal
     * <p>GREATER if search key is greater than target key
     * <p>LESS if search key is less than target key
     */
    public byte compare(byte[] key1Buffer, byte[] key2Buffer, int offset,
    							int length) {
	int key1, key2;

	key1 = Converter.readInt(key1Buffer, 0);
	key2 = Converter.readInt(key2Buffer, offset);

	if (key1 == key2) {
	    return EQUAL;
	} else if (key1 > key2) {
	    return GREATER;
	} else {
	    return LESS;
	}
    }
	
    /**
     * Returns the length of an integer
     * 
     * @return	always returns 4
     */
    public int getLength() {
        return 4;
    }

    public boolean isFixedLength() {
        return true;
    }

}
