/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreeindex;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.*;	/* for MOFID */
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.util.Logger;

/**
 * EntryTypeInfo implementation for type MOFID
 *
 * @author	Dana Bergen
 * @version	1.0
 */

public class MOFIDInfo extends EntryTypeInfo{

    private BtreeStorage storage;

    MOFIDInfo(Storage storage) {       
        this.storage = (BtreeStorage) storage;        
    }
        
    public String typeName() {
        return "MOFID";
    }

    /**
     * Compares two MOFIDs byte-by-byte.
     *
     * @param key	byte array containing search key
     * @param buffer	buffer containing target key
     * @param offset	offset into buffer of target key
     * @param length	should always be MOFID.LENGTH
     *
     * @return	Returns one of:
     * <p>EQUAL if the two keys are equal
     * <p>GREATER if search key is greater than target key
     * <p>LESS if search key is less than target key
     */
    public byte compare(byte[] key, byte[] buffer, int offset, int targetLength) {

	byte k, b;
	for (int i = 0; i < MOFID.LENGTH; i++) {
	    k = key[i];
	    b = buffer[offset+i];
	    if (k < b) {
	        return LESS;
	    } else if (k > b) {
	        return GREATER;
	    } 
        }
        return EQUAL;
    }

    public int getLength() {
        return MOFID.LENGTH;
    }

    public boolean isFixedLength() {
        return true;
    }

    public byte[] toBuffer(Object object) {

        try {
            MOFID m = (MOFID) object;
            if (m != null) {
                byte[] mofBytes = new byte[MOFID.LENGTH];
                Converter.writeLong(mofBytes, 0, m.getSerialNumber());
                String storageId = m.getStorageID ();
                int s;
                if (storage.getStorageId ().equals(storageId)) {
                    s = BtreeFactory.SAME_PREFIX_CODE;
                } else if (BtreeFactory.INTERNAL_PREFIX.equals (storageId)) {
                    s = BtreeFactory.INTERNAL_PREFIX_CODE;
                } else {
                    s = storage.storageIdToNumber (storageId);
                }
                Converter.writeShort(mofBytes, 0, (short)s);
                return mofBytes;
            }
        } catch (Exception e) {
            Logger.getDefault().notify(Logger.INFORMATIONAL, e);
        }
	return null;
    }

    public Object fromBuffer(byte[] buffer) {
	try {
            int storageNumber = Converter.readShort (buffer, 0);
            String storageId = null;
            switch (storageNumber) {
                case BtreeFactory.INTERNAL_PREFIX_CODE:
                    storageId = BtreeFactory.INTERNAL_PREFIX;
                break;
                case BtreeFactory.SAME_PREFIX_CODE:
                    storageId = storage.getStorageId ();
                break;
                default:
                    storageId = storage.numberToStorageId (storageNumber);
            }            
            buffer [0] = 0;
            buffer [1] = 0;            
            long serialNumber = Converter.readLong (buffer, 0);
            return new MOFID (serialNumber, storageId);            
	} catch (Exception e) {
            Logger.getDefault().notify(Logger.INFORMATIONAL, e);
            return null;
        }
    }
   
    public Object objectFromBuffer(byte[] buffer, SinglevaluedIndex repos) {
        try {            
            return storage.resolveObject((MOFID) fromBuffer(buffer)); 
        } catch (Exception e) {
            Logger.getDefault().notify(Logger.INFORMATIONAL, e);            
        }
        return null;
    }
}
