/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.util.Map;
import org.netbeans.mdr.persistence.*;
import org.netbeans.mdr.util.Logger;

/**
* Create a BtreeStorage
*/
public class BtreeFactory implements StorageFactory {
    public static final String DEFAULT_FILE_NAME = "mdr";
    public static final String STORAGE_FILE_NAME = "org.netbeans.mdr.persistence.btreeimpl.filename";       // NOI18N
    public static final String CACHE_SIZE = "org.netbeans.mdr.persistence.btreeimpl.cacheSize"; // NOI18N
    public static final String CACHE_THRESHHOLD = "org.netbeans.mdr.persistence.btreeimpl.cacheThreshHold"; // NOI18N
    public static final String CACHE_INSTANCE = "org.netbeans.mdr.persistence.btreeimpl.cacheInstance"; // NOI18N
    public static final String STORAGE_UUID = "org.netbeans.mdr.persistence.btreeimpl.uuid";       // NOI18N
    
    // Btree MOFID constnants
    static final public int SAME_PREFIX_CODE = 0;
    static final public int INTERNAL_PREFIX_CODE = 1;
    static final public int FIRST_EXTERNAL_CODE = 2;


    /* MOFIDs lower than this are internal, and use the
       internal prefix */
    static final public int FIRST_EXTERNAL_ID = 128;

    /* prefix used for internal objects */
    static final public String INTERNAL_PREFIX = "00000000-0000-0000-0000-000000000000"; // NOI18N
    
        /** MOFID signifying null MOFID */
    public static MOFID nullMOFID = new MOFID(1, INTERNAL_PREFIX);

    /** MOFID for index of secondary indexes */
    public static MOFID indexIndexId = new MOFID(2, INTERNAL_PREFIX);

    /** MOFID for index of classes stored in repository */
    public static MOFID classIndexId = new MOFID(3, INTERNAL_PREFIX);

    /** Creates BtreeStorage
    * @parameter name base name of Btree files
    */
    public Storage createStorage (Map properties) throws StorageException {
        String name = (String) properties.get (STORAGE_FILE_NAME);
        if (name == null) {
            name = DEFAULT_FILE_NAME;
            Logger.getDefault().log("Property " + STORAGE_FILE_NAME + " not specified. Using default value: " + DEFAULT_FILE_NAME);
        }
        Logger.getDefault().log("Storage file name: " + name);
        return new BtreeStorage(name, properties);
    }

    /** null MOFID */
    public org.netbeans.mdr.persistence.MOFID createNullMOFID () {
    	return nullMOFID;
    }
}

    
