/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.lang.ref.*;

import org.netbeans.mdr.persistence.*;

/** A member of the MDR cache.  This is a soft reference to an object
* identified by a MOFID.
*/
//class CacheReference extends SoftReference {
// BHM - lets try more memory friendly 
class CacheReference extends WeakReference {

    /* The MOF ID of the object we reference */
    private Object key;
    
    private Object hardRef;

    /* Whether the reference is currently in the cache */
    // boolean inCache;

    /** Create a reference 
    * @param m the MOF ID of the referenced object
    * @param o the referenced object
    * @param q our reference queue
    */
    CacheReference(Object m, Object o, ReferenceQueue q) {
        super(o, q);
        key = m;
    }

    /** A CacheReference is represented by the same string as its MOF ID */
    public String toString() {
        return key.toString();
    }

    /** A CacheReference hashes to the same number as its MOF ID */
    public int hashCode() {
        return key.hashCode();
    }

    /** Two CacheReferences are equal if their MOF IDs are equal */
    public boolean equals(Object o) {
        if (!(o instanceof CacheReference))
            return false;

        CacheReference cr = (CacheReference)o;
        return cr.key.equals(key);
    }
    
    /** Calling this method makes the reference to be a hard reference
     */
    public void harden() {
        hardRef = get();
    }
    
    /** Calling this method makes the reference weak again
     */
    public void weaken() {
        hardRef = null;
    }
    
    /** Returns true if the reference is hard
     */
    public boolean isHard() {
        return hardRef != null;
    }
    
    
    /** Overriden clear to weaken possibly hardened reference
     */
    public void clear() {
        weaken();
        key = null;
        super.clear();
    }
    
    
    /** Returns the key of the referece */
    Object getKey() {
        return key;
    }
    
}
