/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.io.*;
import java.text.*;
import java.util.*;
import org.netbeans.mdr.persistence.*;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.*;

/**
* This is an index from names (Strings) to Integer.  Its primary use is to 
* store the codes for classes stored in the repository.
*/
public class CounterIndex extends NameIndex {

    /* next integer to be assigned */
    int nextInt = 0;

    /** Create a new CounterIndex  */
    public CounterIndex() {
    }

    /** get an integer by its name.  If none exists, throw an exception
    * @param name the name associated with the integer
    */
    public synchronized int get(String name) throws StorageException  {
    	return ((Integer)getObj(name)).intValue();
    }

    /** get an integer by its name.  If none exists, return null
    * @param name the name associated with the integer
    */
    public synchronized Integer getIf(String name) throws StorageException  {
    	return (Integer)getObjIf(name);
    }

    /**
    * Add a name-MOFID pair to the MofidIndex.  If one already existed,
    * throw an exception.
    * @param name name of object to add to index
    * @param id MOFID of object to add
    */
    public synchronized int add(String name) throws StorageException {
	int i = nextInt++;
    	addObj(name, new Integer(i));
	return i;
    }

    /* write to a DataOutputStream
    */
    public synchronized void write(DataOutputStream dstrm) throws StorageException{
	super.write(dstrm);
	try {
	    dstrm.writeInt(nextInt);
	}
	catch (IOException ex) {
	    throw new StorageIOException(ex);
	}
    }

    /** read from a DataOutputStream
    */
    public synchronized void read(DataInputStream dstrm) throws StorageException{
	super.read(dstrm);
	try {
	    nextInt = dstrm.readInt();
	}
	catch (IOException ex) {
	    throw new StorageIOException(ex);
	}
    }

    /**
    * write object to stream.  Used by serialization.
    * @param obj object to write
    * @param strm stream to write it to
    */
    protected void writeObjectToStream(Object obj, DataOutputStream strm) 
    	throws StorageException {
	try {
	    strm.writeInt(((Integer)obj).intValue());
	}
	catch (IOException ex) {
	    throw new StorageIOException(ex);
	}
    }

    /**
    * read object from stream.  Used by deserialization.
    * @param strm stream to read from
    * @return obj object read
    */
    protected Object readObjectFromStream(DataInputStream strm) 
    	throws StorageException {
	try {
	    return new Integer(strm.readInt());
	}
	catch (IOException ex) {
	    throw new StorageIOException(ex);
	}
	
    }
}



