/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.io.*;
import java.util.*;

/** This is an extent which is part of a record which has been deleted,
* and is available for reuse
*/
class DeletedBtreeExtent extends BtreeExtent {

    /** Create a new DeletedBtreeExtent
    * @param file the BtreeDataFile this extent will belong to
    * @param chunkNum where this extent begins
    * @param numChunks the size of the extent
    */
    DeletedBtreeExtent(BtreeDataFile file, int chunkNum, short numChunks) {
        super(file, chunkNum, numChunks);
    }

    /** Convert an active extent to a deleted one when a record is
    * deleted
    * @param extent the extent being deleted
    */
    DeletedBtreeExtent(ActiveBtreeExtent extent) {
        super(extent);
        headerIsDirty = true;
        owner.deleteExtent(this);
    }
        
    /** read type-specific header data.  A no-op, since DeletedBtreeExtents
    * have none.
    * @param buffer the buffer to read from
    * @param offset the offset to being reading at
    */
    void readHeaderFromPage(byte buffer[], IntHolder offset) {
        // we have no type-specific data
    }

    /** Get the magic number for this type of extent
    * @return the magic number
    */
    short getMagic() {
        return DELETED_MAGIC;
    }

    /** write the type-specific part of the header.  A no-op, since 
    * DeletedBtreeExtents have none.
    * @param page the page to write to
    * @param offset the offset to begin an
    */
    protected void writeHeaderToPage(CachedPage page, int offset) {
        // we have no type-specific data
    }

    /** return type of extent
    * @return IS_DELETED
    */
    byte getType() {
        return IS_DELETED;
    }

    /** return name of type of extent
    * @return DELETED_NAME
    */
    String getTypeName() {
        return DELETED_NAME;
    }
}
